#include "RocketRacer.h"

// create object and specifiy pins
FXOS8700CQ device(I2C_SDA,I2C_SCL);

//default constructor of the class and initializing the private variables
RocketRacer::RocketRacer()
:first_enemy_position(0),second_enemy_position(0),enemy_phase(0),
game_speed (0),score(0),pitchAngle(0.0),Init_position(2),enemy_dead(true),control(true)
{}

//destructor of the class
RocketRacer::~RocketRacer(){
}

/////////setters/////////////////

//sets the enemy position
void RocketRacer::set_first_position(int first_enemy_position) {
 first_enemy_position = first_enemy_position;
}

//sets the second enemy position
void RocketRacer::set_second_position(int second_enemy_position) {
 second_enemy_position = second_enemy_position;
}


void RocketRacer::set_enemy_phase(int enemy_phase) {
 enemy_phase = enemy_phase;
}

//sets the game speed
void RocketRacer::set_game_speed(int game_speed) {
 game_speed = game_speed;
}

//sets the game score
void RocketRacer::set_game_score(int score) {
 score = score;
}

//sets the flag enemy_dead
void RocketRacer::set_enemy_dead(bool enemy_dead) {
 enemy_dead = enemy_dead;
}

//sets the flag control
void RocketRacer::set_control(bool control) {
 control = control;
}

//sets the initial position
void RocketRacer::set_init_position(int Init_position) {
 Init_position = Init_position;
}

/////////Game Methods/////////////////

void RocketRacer::Main_Game_Display(N5110 &lcd){
    
    lcd.clear(); //clears the lcd 
    lcd.drawRect(0,0,46,47,FILL_BLACK);//draws a transparent rectangle on the lcd
    char score_buffer[14];//buffer to store the score 
    char score_buffer1[14];
    char level_buffer[14];//buffer to store the current level 
    char level_buffer1[14];  
    //display score
    sprintf(score_buffer,"score");
    lcd.printString(score_buffer,55,0);
    sprintf(score_buffer1,"%d",score);
    lcd.printString(score_buffer1,58,1);
    lcd.drawLine(15, 2, 15,48,0);
    lcd.drawLine(30, 2, 30,48,0);
    //display level
    sprintf(level_buffer,"Level");
    lcd.printString(level_buffer,55,3);
    sprintf(level_buffer1,"%d",game_speed);
    lcd.printString(level_buffer1,58,4);
    lcd.refresh();//refreshes the lcd to render   
}


void RocketRacer::accelerometer_position(Gamepad &pad){
    
    pitchAngle = device.get_pitch_angle();//gets the pitch angle
    //statement to check if the gamepad rolled to the right
    if( (pitchAngle > 100)&& Init_position!=3 && control==true){
        Init_position++;//increments the position of the player sprite 
        control = false; //sets the flag to false
        wait(0.1);// small delay to prevent previous press being detected again
//        printf("its Right\n");
    }
    //statement to check if the gamepad rolled to the left
    else if( (pitchAngle < 90 )&& Init_position!=1 && control==true){
        Init_position--;//decrements the position of the player sprite
        control = false;//sets the flag to false
        wait(0.01);// small delay to prevent previous press being detected again
//        printf("its left\n");
    }
    else {//statement to check if the joystick position is center
        control = true;//sets the flag to true
        wait(0.01);
//        printf("its center\n");
        }    
}


void RocketRacer::Joystick_position(Gamepad &pad){
    //assigning d to the method to get the joystick direction  
    Direction d=pad.get_direction();

    if( (d==E||pad.check_event(Gamepad::R_PRESSED) == true )
     && Init_position!=3 && control==true){//statement to check if the joystick moved right
        Init_position++;//increments the position of the player sprite 
        control = false; //sets the flag to false
        wait(0.09);// small delay to prevent previous press being detected again
//        printf("its Right\n");
    }
    else if( (d==W ||pad.check_event(Gamepad::L_PRESSED) == true )
    && Init_position!=1 && control==true){//statement to check if the joystick moved left
        Init_position--;//decrements the position of the player sprite
        control = false;//sets the flag to false
        wait(0.01);// small delay to prevent previous press being detected again
//        printf("its left\n");
    }
    else if(d==CENTRE){//statement to check if the joystick position is center
        control = true;//sets the flag to true
        wait(0.01);
//        printf("its center\n");
        }
}





void RocketRacer::Generate_New_Enemy(){
  
  srand(time(NULL));//seeding the random function
  
  if (enemy_dead){//statement to check if the enemy crossed the player sprite 
    first_enemy_position = Init_position;//places the first enemy above the player's sprite  
    second_enemy_position = (rand() % 3)+1;//generates a random number from 1 to 3 
    //printf("%d",second_enemy_position);
    enemy_phase = 0; 
    enemy_dead = false;
    }
}

   
void RocketRacer::Check_Enemy_Dead(N5110 &lcd,Gamepad &pad){
     //statement to check if the enemies collided with the rocket         
     if (enemy_phase>23 && ((first_enemy_position== Init_position)
      || (second_enemy_position == Init_position)) ){ 
         End_Game(pad,lcd);//calls the end game method that displays game over screen
           
     }
     if (enemy_phase>39){//statement to check if the enemies crossed without colliding with the rocket 
         enemy_dead = true;
         score++;//increments the score
     }
}
 
    
void RocketRacer::Game_Loop_accelerometer(N5110 &lcd,Gamepad &pad){
    
    lcd.clear(); //clears the lcd
    //calls the method to get the joystick direction according to the user
    accelerometer_position(pad);
    //calls the method to draw the sprites according to accelerometer postion
    player_position(lcd,Init_position);  
    Generate_One_Enemy();//generate 1 new enemy
    //places the first enemy according to the position
    enemy_position(lcd,first_enemy_position, enemy_phase);
    enemy_phase++;//increments the current phase of the enemy
    //places the second enemy according to the position
    enemy_position(lcd,second_enemy_position, enemy_phase);
    enemy_phase++;//increments the current phase of the enemy
    
    Check_Enemy_Dead(lcd,pad);//checks if enemies crossed the rocket
    
    Game_difficulty(pad); //adds difficulty to the game 
    
    lcd.refresh();//refreshes the screen
}


void RocketRacer::Generate_One_Enemy(){
  
  srand(time(NULL));//seeding the random function
  
  if (enemy_dead){//statement to check if the enemy crossed the player sprite  
    second_enemy_position = (rand() % 3)+1;//generates a random number from 1 to 3 
    //printf("%d",second_enemy_position);
    enemy_phase = 0; 
    enemy_dead = false;
    }
}

    
void RocketRacer::Game_Loop(N5110 &lcd,Gamepad &pad){
    lcd.clear(); //clears the lcd
    
    Joystick_position(pad);//calls the method to get the joystick direction according to the user
    player_position(lcd,Init_position);//calls the method to draw the sprites according to joystick postion
    
    Generate_New_Enemy();//generate 2 new enemies
    
    enemy_position(lcd,first_enemy_position, enemy_phase);//places the first enemy according to the position
    enemy_phase++;//increments the current phase of the enemy
    enemy_position(lcd,second_enemy_position, enemy_phase);//places the second enemy according to the position
    enemy_phase++;//increments the current phase of the enemy
    
    Check_Enemy_Dead(lcd,pad);//checks if enemies crossed the rocket
    
    Game_difficulty(pad); //adds difficulty to the game 
    
    lcd.refresh();//refreshes the screen
}


//adds difficulty to the game after proceeding with each level
void RocketRacer::Game_difficulty(Gamepad &pad){
     if (score>=0 && score<=5){
        pad.led(1,1.0); game_speed = 1;//first led on to indicate level 1 
         wait(0.09);//reduces the wait on each level
    }if (score>5 && score<=10){
      pad.led(2,1.0); game_speed = 2;//first&second leds on to indicate level 2
         wait(0.07);
    }if (score>10 && score<=20){
        pad.led(3,1.0); game_speed = 3;//1,2,3 leds on to indicate level 3 
        wait(0.06); 
    }if (score>20 && score<=25){//1,2,3,4 leds on to indicate level 4 
        pad.led(4,1.0); game_speed = 4; 
        wait(0.05); 
    }if (score>25 && score<=30){//1,2,3,4,5 leds on to indicate level 5 
        pad.led(5,1.0); game_speed = 5; 
        wait(0.04); 
    }if (score>30){//all 6 leds on to indicate level 6 
       pad.led(6,1.0); game_speed = 6;
        wait(0.03);
    }
}


void RocketRacer::enemy_position(N5110 &lcd,int place, int phase){
  
  if (place==1){//draws the enemy sprite at position 1
      lcd.drawSprite(3,phase,11,9,(int *)enemy);
      }
  
  if (place==2){//draws the enemy sprite at position 2
      lcd.drawSprite(19,phase,11,9,(int *)enemy);
      }
  
  if (place==3){//draws the enemy sprite at position 3
      lcd.drawSprite(35,phase,11,9,(int *)enemy);
      }
      lcd.refresh();
  
}


void RocketRacer::player_position(N5110 &lcd,char RocketPosition){
  
  Main_Game_Display(lcd);//displays the game screen
  
  if (RocketPosition==1){//places the rocket at positon 1   
      lcd.drawSprite(3,34,11,9,(int *)rocket);
      }
  if (RocketPosition==2){//places the rocket at positon 2
      lcd.drawSprite(19,34,11,9,(int *)rocket);
      }
  if (RocketPosition==3){//places the rocket at positon 3
      lcd.drawSprite(35,34,11,9,(int *)rocket);
      }
      lcd.refresh();
}


void RocketRacer::End_Game(Gamepad &pad,N5110 &lcd){
    
    lcd.clear();
    char buffer1[14];
    //prints the gameover to the lcd with the score achieved
    lcd.printString("Game over!!!",5,0);
    lcd.printString("Better Luck ",2,1);
    lcd.printString("next time",2,2);
    lcd.printString("High score:",2,3);
    sprintf(buffer1,"%d",score);
    lcd.printString(buffer1,20,4); 
    
    pad.leds_on();//turns all leds on    
    lcd.refresh();
    tones.End_Game_Melody(pad); //calling tones object to play melody
    
    
    wait(50);
    
}
    
