//Defining and Including stuff up here
#include "mbed.h"
#include "SHTx/sht15.hpp"
#include <7_segment_control.h>
#include <compare.h>
#include <data_out.h>
#include <logging.h>
#include <Settings.h>
#include <rgb_led.h>
#include <Ticker.h>

//Declaration of GLOBAL VARIABLES:
float temperature, humidity;            //this will be data read from sensor
void GetTemperatureAndHumidity();       //via denne function

int temperature_low=18;     //DELETE LATER!
int temperature_high=22;    //DELETE LATER!

Serial pc(USBTX, USBRX);
InterruptIn event(USER_BUTTON);
DigitalOut myled(LED1);
DigitalIn up(PA_5);
DigitalIn down(PA_6);
SHTx::SHT15 sensor(PB_8, PB_9);         //ports on the Nucleo: PB_8, PB_9

Ticker tick1;
Ticker tick2;
Ticker tick3;
Ticker tick4;

int main()
{
        tick1.attach(&Settings(), 20);                    //Settings
        tick2.attach(&GetTemperatureAndHumidity(),20);  //Data Collection
        tick3.attach(&Compare_values(),20);             //Data Analysis
        tick4.attach(&rgb_outp(),20);                   //RGB_LED_output
    
    while(1) {
        logging ();

        
        //tick2.attach(&GetTemperatureAndHumidity(),20);        //Data Collection
        //tick3.attach(&Compare_values(humidity, temperature, temperature_low, temperature_high),20); //Data Analysis
        //tick4.attach(&rgb_outp(Compare_values(humidity, temperature, temperature_low, temperature_high)),20);  //RGB_LED_output

    }
}


void GetTemperatureAndHumidity() //can't move to the .h file, pga "sensor" definitions.
{

// Speed things up a bit.
    sensor.setOTPReload(false);
    sensor.setResolution(true);

    //busy = true;
    sensor.update();
    //busy = false;

    // Temperature in celcius
    sensor.setScale(false);
    temperature=sensor.getTemperature();

    // Relative Humidity
    humidity=sensor.getHumidity();

    wait(5);
    return;
}