
/**************rele-counter v2  **********************************/
//	при включении  реле выключено, тек.показания и уставка как до выключения, 
//	но подсчет импульсов не работает до подачи 1го импульса на сброс.
//	после подачи  1го имп.сброс - показания сбрасываются реле включается
//	при достижении  подсчитанных импульсов уставки - реле отключается
//	при повторной подаче  сигнала сброс, показания сбрасываются и реле включается
//
//


#include "mbed.h"
#include "rtos.h"
#include "TM1638.h"
#include "AT45.h"


// -------  input/output  ----------------
DigitalOut  led(PC_13);
DigitalOut  rel(PA_15);
DigitalIn   in1(PA_8);
DigitalIn   in2(PA_9);
DigitalIn   in3(PA_10);

//  -------  displey --------------------
TM1638_LEDKEY8 LEDKEY8(PB_15,PB_14,PB_13, PB_12);
TM1638::KeyData_t keydata; 


//----------- SPI FLASH  ------------------------
SPI 	spi(PA_7, PA_6, PA_5); 	// mosi, miso, sclk
AT45 	spif(&spi, PA_4);		// NSS

char *spi_buffer = (char*) malloc(64);
char str[10]; 


// --------  глоб.переменные ---------------
int present_val = 0;				// текущее заначение 
int present_val_last = 0;			// текущее значение (старое)
int max_value = 0;					// значение  вкл. реле

int  led1=0;						//  индикация LED1
int  led2=0;						//  индикация LED2
int  led3=0;						//  индикация LED3

int  enbl=0;						//  разрешение на работу 

// --------  Прототипы функций:  ----------
void count_value();


/********************************************************************/
int main() {
	
    //  предустановка  значений 
    int update = 0;
    int update2 = 0;
    int delay_update_x10 = 2000;			//  задержка  перед  +/-  x_inreasing_decreasing
    int time_update_increase = 0;			//  отсчет времени до  +10
    int time_update_decrease = 0;			//  отсчет времени до -10
    int delay_cycle = 25;					//  период вывода инф. на дисплей
    int once_increase = 0;
    int once_decrease = 0;
    int x_inreasing_decreasing = 10;		//	+/-  после удержания кнопки
   
    
    int write_page_time = 5000;				//  время до  записи  max_value
    int timer_to_write_page = 0;			//  отсчет времени до  записи  max_value
    int write_page_start = 0;				//  старт процедуры записи 
    
    
    // Вычитываем сохраненное максимальное значение (11 стр для записи)
    spif.read_page(spi_buffer, 11);
    max_value = atoi(spi_buffer);
    
    // Вычитываем сохраненное текущее значение (12 стр для записи)
    spif.read_page(spi_buffer, 12);
    present_val = atoi(spi_buffer);
    
    // Делаем текущее значение != текущему прошлому значение
    present_val_last = present_val + 10;
    
    // Поток для работы с текущим значением
    Thread count_thread;
    count_thread.start(count_value);
    
	
	while(1) {
		
		/***  обработка нажатия кнопок   ***/
		
		LEDKEY8.getKeys(&keydata);
		
		// Нажимаем кнопку X, текущее значение = 0
		if(keydata[LEDKEY8_SW3_IDX] == LEDKEY8_SW3_BIT) {
			present_val = 0;
			enbl=1;
		}
		
		
		// Нажимаем кнопку увеличить 
		if(keydata[LEDKEY8_SW1_IDX] == LEDKEY8_SW1_BIT) {
			if(keydata[LEDKEY8_SW2_IDX] != LEDKEY8_SW2_BIT) {
				time_update_increase = time_update_increase + delay_cycle;
				
				// Один раз делаем +1
				if(once_increase == 0) {
					once_increase = 1;
					if(max_value<999){max_value = max_value + 1;}
					update = 0;
				}
				
				write_page_start = 1;
				timer_to_write_page = 0;
			}
		}
		else {
			time_update_increase = 0;
			once_increase = 0;
		}
		
		
		
		// Нажимаем кнопку уменьшить
		if(keydata[LEDKEY8_SW2_IDX] == LEDKEY8_SW2_BIT) {
			if(keydata[LEDKEY8_SW1_IDX] != LEDKEY8_SW1_BIT) {
				time_update_decrease = time_update_decrease + delay_cycle;
				
				// Один раз делаем -1
				if(once_decrease == 0) {
					once_decrease = 1;
					if(max_value>0){max_value = max_value - 1;}
					update = 0;
				}
				
				write_page_start = 1;
				timer_to_write_page = 0;
			}
		}
		else {
			once_decrease = 0;
			time_update_decrease = 0;
		}
		
		
		
		
		// При удержании кнопки увеличить  на +10
		if(keydata[LEDKEY8_SW1_IDX] == LEDKEY8_SW1_BIT) {
			if(time_update_increase >= delay_update_x10) {
				time_update_increase = delay_update_x10 - delay_cycle*10;
				if(max_value<=990){max_value = max_value + x_inreasing_decreasing;}
				update = 0;
			}
		}
		
		
		
		
		// При удержании  кнопки уменьшить на -10
		if(keydata[LEDKEY8_SW2_IDX] == LEDKEY8_SW2_BIT) {
			if(time_update_decrease >= delay_update_x10) {
				time_update_decrease = delay_update_x10 - delay_cycle*10;
				if(max_value>10){max_value = max_value - x_inreasing_decreasing;}
				update = 0;
			}
		}
		
		
		
		// Записываем в память максимальное значение 
		// через время write_page_time после нажатий кнопок
		if(write_page_start == 1) {
			timer_to_write_page = timer_to_write_page + delay_cycle;
			
			if(timer_to_write_page >= write_page_time) {
				write_page_start = 0;
				timer_to_write_page = 0;
				sprintf(spi_buffer, "%d", max_value);
				spif.page_erase(11);  
				spif.write_page(spi_buffer, 11);
				
				LEDKEY8.locate(0);
				LEDKEY8.printf("   ");
				Thread::wait(500);
				LEDKEY8.locate(0);
				LEDKEY8.printf("%d", max_value);
			}
		}
		
		
		
		/***  вывод на дисплей  ***/
		
		led = !led ;
		
		LEDKEY8.cls();
		LEDKEY8.setBrightness(TM1638_BRT1);
		LEDKEY8.locate(0);
		LEDKEY8.printf("%d", max_value);
		LEDKEY8.locate(3);
		LEDKEY8.printf("%d", present_val);
		if(led1==1){LEDKEY8.setIcon(TM1638_LEDKEY8::LD1);}else{LEDKEY8.clrIcon(TM1638_LEDKEY8::LD1);}
		if(led2==1){LEDKEY8.setIcon(TM1638_LEDKEY8::LD2);}else{LEDKEY8.clrIcon(TM1638_LEDKEY8::LD2);}
		if(led3==1){LEDKEY8.setIcon(TM1638_LEDKEY8::LD3);}else{LEDKEY8.clrIcon(TM1638_LEDKEY8::LD3);}
				
		
		Thread::wait(delay_cycle);
	}
}

/****************************************************************/

// Поток работы с текущим значением 10msec
void count_value() {
	
	int  c_inp1=0;
	int  c_inp2=0;
	int  c_inp3=0;
	int  m_inp1=0;
	int  m_inp2=0;
	int  m_inp3=0;
	
	int  blnk=0;
	
	while(1) {
		
		if(blnk<100){blnk++;}else{blnk=0;}
		
		//  фиксируем значения
		if(in1==0){c_inp1=1;}else{c_inp1=0;}
		if(in2==0){c_inp2=1;}else{c_inp2=0;}
		if(in3==0){c_inp3=1;}else{c_inp3=0;}
		
		
		// сохраняем тек.значение  в 12 стр. при выкл. питания
		if(c_inp1==0 && m_inp1==1){
			sprintf(spi_buffer, "%d", present_val);
			spif.page_erase(12);  
			spif.write_page(spi_buffer, 12);
		}
		
		// подсчет импульсов по входу 1
		if(c_inp2==1 && m_inp2==0 && enbl==1){
			present_val++;
		}
		
		// сбрасываем текущее значение по входу 2
		if(c_inp3==1 && m_inp3==0){
			enbl=1;
			present_val=0;
		}
		
		
		// управление реле
		if(present_val<max_value && enbl==1){rel=1; }else{rel=0;}
		
		
		// управляем светодиодами
		if(enbl==1){
			if(rel==1){led1=1;}else{led1=0;}
		}else{
			if(blnk<50){led1=1;}else{led1=0;}
		}
		
		
		if(c_inp2==1){led2=1;}else{led2=0;}
		if(c_inp3==1){led3=1;}else{led3=0;}
		

		// сохраняем значени 
		m_inp1=c_inp1;
		m_inp2=c_inp2;
		m_inp3=c_inp3;
		
		
		Thread::wait(5);
	}
}


