
#include <mbed.h>
#include "rtos.h"
#include "can.h"
#include "ext_vars.h"


//-------------хранение полученного  сообщения --------------
//
//                             [b1  b2  b3  b4]
//                             -----------------
// r_mess id[0] -> r_mess_data [ 0   1   2   3] - новое сообщение
// r_mess id[1] -> r_mess_data [ 4   5   6   7]	- новое сообщение
// r_mess id[2] -> r_mess_data [ 8   9  10  11]	- новое сообщение
// r_mess id[3] -> r_mess_data [12  13  14  15]	- новое сообщение
// r_mess id[4] -> r_mess_data [16  17  18  19]	- новое сообщение
// r_mess id[5] -> r_mess_data [20  21  22  23]	- новое сообщение
// r_mess id[6] -> r_mess_data [24  25  26  27]	- новое сообщение
// r_mess id[7] -> r_mess_data [28  29  30  31]	- новое сообщение
// r_mess id[8] -> r_mess_data [32  33  34  35]	- новое сообщение
// r_mess id[9] -> r_mess_data [36  37  38  39]	- новое сообщение


//--------- очередь сообщений на отправку ------------------
//
//                             [b1  b2  b3  b4]
//                             -----------------
// w_mess id[0] -> w_mess_data [ 0   1   2   3] - новое сообщение
// w_mess id[1] -> w_mess_data [ 4   5   6   7]	- новое сообщение
// w_mess id[2] -> w_mess_data [ 8   9  10  11]	- новое сообщение
// w_mess id[3] -> w_mess_data [12  13  14  15]	- новое сообщение
// w_mess id[4] -> w_mess_data [16  17  18  19]	- новое сообщение
// w_mess id[5] -> w_mess_data [20  21  22  23]	- новое сообщение
// w_mess id[6] -> w_mess_data [24  25  26  27]	- новое сообщение
// w_mess id[7] -> w_mess_data [28  29  30  31]	- новое сообщение
// w_mess id[8] -> w_mess_data [32  33  34  35]	- новое сообщение
// w_mess id[9] -> w_mess_data [36  37  38  39]	- новое сообщение




//  помещаем в очередь полученное сообщение 
int  can_save_rd(int id, char b1, char b2, char b3, char b4)
{
	int res = 0 ; 
	for(int i=0; i<9; i++){
		if( r_mess_id[i]==0 && res==0){
			r_mess_id[i] = id;
			r_mess_data[i*3+i+0] = b1;
			r_mess_data[i*3+i+1] = b2;
			r_mess_data[i*3+i+2] = b3;
			r_mess_data[i*3+i+3] = b4;
			res = 1;
		}
	}
	return res;
}


//  помещаем в очередь сообщения для отправки
int  can_save_wr(int id, char b1, char b2, char b3, char b4)
{
	int res = 0 ; 
	for(int i=0; i<9; i++){
		if( w_mess_id[i]==0 && res==0){
			w_mess_id[i] = id;
			w_mess_data[i*3+i+0] = b1;
			w_mess_data[i*3+i+1] = b2;
			w_mess_data[i*3+i+2] = b3;
			w_mess_data[i*3+i+3] = b4;
			res = 1;
		}
	}
	return res;
}

// выбираем сообщение из очереди для обработки
// и  помещаем в раб. переменные
int  can_select_rd()
{
	int res = 0;
	
	r_id=0;
	r_b1=0;
	r_b2=0;
	r_b3=0;
	r_b4=0;
	
	for(int i=0; i<9; i++){
		if( r_mess_id[i] != 0  && res==0 ) {
			r_id = r_mess_id[i] ;  
			r_b1 = r_mess_data[i*3+i+0];
			r_b2 = r_mess_data[i*3+i+1];
			r_b3 = r_mess_data[i*3+i+2];
			r_b4 = r_mess_data[i*3+i+3];
			r_mess_id[i] = 0 ;
			res=1;
		}
	}
	return res;
}




// выбираем сообщение из очереди для отправки
// и  помещаем в раб. переменные
int  can_select_wr()
{

	int res = 0;
	
	w_id=0;
	w_b1=0;
	w_b2=0;
	w_b3=0;
	w_b4=0;
	
	for(int i=0; i<9; i++){
		if( w_mess_id[i] != 0  && res==0 ) {
			w_id = w_mess_id[i] ; 
			w_b1 = w_mess_data[i*3+i+0];
			w_b2 = w_mess_data[i*3+i+1];
			w_b3 = w_mess_data[i*3+i+2];
			w_b4 = w_mess_data[i*3+i+3];
			w_mess_id[i] = 0 ;
			res=1;
		}
	}
	
	return res;
}










