
/***  PLC  F446RE    ***/
// 512 KB Flash  / 128 KB SRAM System  / 4 KB SRAM Backup 

#include "mbed.h"
#include "rtos.h"
#include "AT45.h"
#include "PCAL9555.h"

#include "can.h"
#include "config_io.h"
#include "ext_vars.h"
#include "set_vars.h"

#include "task_ob.h"

#define CAN_BAUD 	50000	// скорость 
#define UART_BAUD 	9600	// скорость 
#define MAX_SERL  	30		// макс. длинна строки из usb/uart




/*******  создание  локальных переменных *************************/

int   	busin = 0; 	
int   	t_sys = 0 ;	

char  	pc_buffer [MAX_SERL+2];
int   	pc_i=0;
int   	pc_im=0;

float	st_start=0.0;
float	st_end=0.0;
float	st_old=0.0; 
float	st_cycl=0.0; 
float	st_task=0.0; 

int 	new_outs=0;

/**********  прототипы локальных функций  **********************/
void 	read_inputs(); 
void 	write_outs();
void    save_stat();
void	logic_tasks();	
void 	can_rw();
void  	timers();
void	pc_rd();
int   	read_val(); 

/**************  Threads  **************************************/
Thread	read_uart; 
Thread  work_can;	
RtosTimer t_10msec(&logic_tasks); 


/*************** старт программы  PLC **************************/
int main()
{
	led=1;
	st.start(); 
	
	// ----- настраиваем CAN  ------ 
	can.frequency(CAN_BAUD);

	//----- настраиваем порт USB  ------ 
	pc.baud(UART_BAUD);
	pc.printf( "\r\n> START PLC \r\n");
	pc.printf(">CPU SystemCoreClock is %d Hz\r\n", SystemCoreClock);


	//------  проверка  FLASH  ----------
	pc.printf("> flash size: %d bytes \n",  spif.device_size());
	
	
	//-------  запускаем  потоки  Thread  ------
	work_can.start(can_rw);	// обмен информ. по CAN
    read_uart.start(pc_rd); // чтение UART
	
   
    //--- запускаем логич.задач по таймеру  10msec ------
    t_10msec.start(10); 		
    

	/***  обработка команд по USB  ***/
    while (true) {
		
		if(t_sys<500){led=1;}else{led=0;}
		led_r=led; 
		
		// проверяем usb
       	if (pc_i>1 && pc_i==pc_im){            
            pc_i = 0;
            //pc.printf("usb:%s",pc_buffer);
            //led = !led;
            

			// ---  устанавливаем значение  переменных ----
            if(strstr(pc_buffer,"=")){
				
				if(strstr (pc_buffer,"vr000")) { vr000=read_val();  pc.printf( "ok\n"); }
				if(strstr (pc_buffer,"vr001")) { vr001=read_val();  pc.printf( "ok\n"); }
				if(strstr (pc_buffer,"vr002")) { vr002=read_val();  pc.printf( "ok\n"); }
								
				if(strstr (pc_buffer,"pr001")) { pr001=read_val();  pc.printf( "ok\n"); }
				if(strstr (pc_buffer,"pr002")) { pr002=read_val();  pc.printf( "ok\n"); }
				
			}
			
			// ---  проверка значения  переменных ----- 
            if(strstr(pc_buffer,"?")){
				
				if(strstr (pc_buffer,"vr000")) { pc.printf( "vr000:%d\n", vr000); }
				if(strstr (pc_buffer,"vr001")) { pc.printf( "vr001:%d\n", vr001); }
				if(strstr (pc_buffer,"vr002")) { pc.printf( "vr002:%d\n", vr002); }

				if(strstr (pc_buffer,"pr001")) { pc.printf( "pr001:%d\n", pr001); }
				if(strstr (pc_buffer,"pr002")) { pc.printf( "pr002:%d\n", pr002); }
				
				
				//  для контроля состояния 
				
				if(strstr (pc_buffer,"dc_in"))  { pc.printf( "\n--- PLC --- \n> inputs:%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d\n", x01,x02,x03,x04,x05,x06,x07,x08,x09,x10,x11,x12,x13,x14,x15,x16); }
				if(strstr (pc_buffer,"dc_out")) { pc.printf( "\n--- PLC --- \n> outputs:%d%d%d%d%d%d%d%d%\n", y01,y02,y03,y04,y05,y06,y07,y08);  }
				if(strstr (pc_buffer,"an_in"))  { pc.printf( "\n--- PLC --- \n> an_in1=%f an_in2=%f an_in3=%f an_in4=%f \n", Vin_1, Vin_2, Vin_3, Vin_4 ); }
				if(strstr (pc_buffer,"an_out")) { pc.printf( "\n--- PLC --- \n> an_out1=%f an_out2=%f \n", Vout_1, Vout_2 ); }
				if(strstr (pc_buffer,"stime"))  { pc.printf( "\n--- PLC --- \n> work cycle %f / using %f  sec \n", st_cycl, st_task ); }
				
				if(strstr (pc_buffer,"sm-1"))	{ pc.printf( "\n--- modul SM01 adr=1 --- \n> car position-%d  moving-%d  alarm-%d \n> inputs %d-%d-%d-%d  outputs %d-%d \n", sm1_pos, sm1_mov, sm1_alr, a101, a102, a103, a104, b101, b102 ); }
				if(strstr (pc_buffer,"sm-2"))	{ pc.printf( "\n--- modul SM01 adr=2 --- \n> car position-%d  moving-%d  alarm-%d \n> inputs %d-%d-%d-%d  outputs %d-%d \n", sm2_pos, sm2_mov, sm2_alr, a201, a202, a203, a204, b201, b202 ); }
				if(strstr (pc_buffer,"sm-3"))	{ pc.printf( "\n--- modul SM01 adr=3 --- \n> car position-%d  moving-%d  alarm-%d \n> inputs %d-%d-%d-%d  outputs %d-%d \n", sm3_pos, sm3_mov, sm3_alr, a301, a302, a303, a304, b301, b302 ); }
				if(strstr (pc_buffer,"sm-4"))	{ pc.printf( "\n--- modul SM01 adr=4 --- \n> car position-%d  moving-%d  alarm-%d \n> inputs %d-%d-%d-%d  outputs %d-%d \n", sm4_pos, sm4_mov, sm4_alr, a401, a402, a403, a404, b401, b402 ); }
				
				if(strstr (pc_buffer,"dm-1"))	{ pc.printf( "\n--- modul DM0806  adr=1 --- \n> inputs:%d%d%d%d%d%d%d%d%  \n> outputs:%d%d%d%d%d%d% \n", x101,x102,x103,x104,x105,x106,x107,x108, y101,y102,y103,y104,y105,y106 ); }
				if(strstr (pc_buffer,"dm-2"))	{ pc.printf( "\n--- modul DM0806  adr=2 --- \n> inputs:%d%d%d%d%d%d%d%d%  \n> outputs:%d%d%d%d%d%d% \n", x201,x202,x203,x204,x205,x206,x207,x208, y201,y202,y203,y204,y205,y206 ); }
				if(strstr (pc_buffer,"dm-3"))	{ pc.printf( "\n--- modul DM0806  adr=3 --- \n> inputs:%d%d%d%d%d%d%d%d%  \n> outputs:%d%d%d%d%d%d% \n", x301,x302,x303,x304,x305,x306,x307,x308, y301,y302,y303,y304,y305,y306 ); }
				if(strstr (pc_buffer,"dm-4"))	{ pc.printf( "\n--- modul DM0806  adr=4 --- \n> inputs:%d%d%d%d%d%d%d%d%  \n> outputs:%d%d%d%d%d%d% \n", x401,x402,x403,x404,x405,x406,x407,x408, y401,y402,y403,y404,y405,y406 ); }
				
			}
			
			if(strstr (pc_buffer,"reset")) { NVIC_SystemReset() ; }
			
			

		 } 

		pc_im=pc_i; 
        Thread::wait(100);
    }
    
}


/****************  дополнительные  функции  **********************/

// логические  задачи.  вызываются для выполнения
// каждые 10 мсек
void logic_tasks(){
	// чтение сист.таймера
	st_start=st.read();
	
	
	// подготовка входн.информации
	timers();        
	read_inputs();
	
	// логичкские задачи
	task_ob(); 
	
	// формирование выходн.информации
	write_outs(); 
	save_stat();
	
	// определяем реальное время цикла/использ.время
	st_end=st.read();
	st_task=st_end-st_start;
	st_cycl=st_start-st_old;
	st_old=st_start;

}


//----------------------------------------
// установка   выходов  контроллера
// в соответствии  значения преременным
void write_outs(){
	// устанавливаем локальные выходы ПЛК
	y_1=y01;	y_5=y05;
	y_2=y02;	y_6=y06;
	y_3=y03;	y_7=y07;
	y_4=y04;	y_8=y08; 
	
	anout1=Vout_1;
    anout2=Vout_2;
    
	//  упаковываем  выходы для DM0806 ADR=1 
	dm1_outs = 0;
	if(y106==1){dm1_outs = dm1_outs |1;}		// y106
	dm1_outs = dm1_outs << 1; 
	if(y105==1){dm1_outs = dm1_outs |1;}		// y105
	dm1_outs = dm1_outs << 1; 
	if(y104==1){dm1_outs = dm1_outs |1;}		// y104
	dm1_outs = dm1_outs << 1; 
	if(y103==1){dm1_outs = dm1_outs |1;}		// y103
	dm1_outs = dm1_outs << 1;
	if(y102==1){dm1_outs = dm1_outs |1;}		// y102
	dm1_outs = dm1_outs << 1;
	if(y101==1){dm1_outs = dm1_outs |1;}		// y101
	
	//  упаковываем  выходы для DM0806 ADR=2
	dm2_outs = 0;
	if(y206==1){dm2_outs = dm2_outs |1;}		// y206
	dm2_outs = dm2_outs << 1; 
	if(y205==1){dm2_outs = dm2_outs |1;}		// y205
	dm2_outs = dm2_outs << 1; 
	if(y204==1){dm2_outs = dm2_outs |1;}		// y204
	dm2_outs = dm2_outs << 1; 
	if(y203==1){dm2_outs = dm2_outs |1;}		// y203
	dm2_outs = dm2_outs << 1;
	if(y202==1){dm2_outs = dm2_outs |1;}		// y202
	dm2_outs = dm2_outs << 1;
	if(y201==1){dm2_outs = dm2_outs |1;}		// y201
	
	//  упаковываем  выходы для DM0806 ADR=3
	dm3_outs = 0;
	if(y306==1){dm3_outs = dm3_outs |1;}		// y306
	dm3_outs = dm3_outs << 1; 
	if(y305==1){dm3_outs = dm3_outs |1;}		// y305
	dm3_outs = dm3_outs << 1; 
	if(y304==1){dm3_outs = dm3_outs |1;}		// y304
	dm3_outs = dm3_outs << 1; 
	if(y303==1){dm3_outs = dm3_outs |1;}		// y303
	dm3_outs = dm3_outs << 1;
	if(y302==1){dm3_outs = dm3_outs |1;}		// y302
	dm3_outs = dm3_outs << 1;
	if(y301==1){dm3_outs = dm3_outs |1;}		// y301
	
	
	//  упаковываем  выходы для DM0806 ADR=4
	dm4_outs = 0;
	if(y406==1){dm4_outs = dm4_outs |1;}		// y406
	dm4_outs = dm4_outs << 1; 
	if(y405==1){dm4_outs = dm4_outs |1;}		// y405
	dm4_outs = dm4_outs << 1; 
	if(y404==1){dm4_outs = dm4_outs |1;}		// y404
	dm4_outs = dm4_outs << 1; 
	if(y403==1){dm4_outs = dm4_outs |1;}		// y403
	dm4_outs = dm4_outs << 1;
	if(y402==1){dm4_outs = dm4_outs |1;}		// y402
	dm4_outs = dm4_outs << 1;
	if(y401==1){dm4_outs = dm4_outs |1;}		// y401	
	
	
	// при изменении по DM0806 посылаем в CAN
    if(dm1_outs!=mdm1_outs || dm2_outs!=mdm2_outs || dm3_outs!=mdm3_outs || dm4_outs!=mdm4_outs){
		int  _id=50;
		char _b1= dm1_outs;
		char _b2= dm2_outs ;
		char _b3= dm3_outs ;
		char _b4= dm4_outs ;
		can_save_wr(_id,_b1,_b2,_b3,_b4);
	}
	
	
	//  упаковываем  выходы для SM01 ADR=1-4 
	sm_outs=0; 
	if(b402==1){sm_outs = sm_outs |1;}			// b402
	sm_outs = sm_outs << 1;		
	if(b401==1){sm_outs = sm_outs |1;}			// b401
	sm_outs = sm_outs << 1;		
	if(b302==1){sm_outs = sm_outs |1;}			// b302
	sm_outs = sm_outs << 1;		
	if(b301==1){sm_outs = sm_outs |1;}			// b301
	sm_outs = sm_outs << 1;		
	if(b202==1){sm_outs = sm_outs |1;}			// b202
	sm_outs = sm_outs << 1;		
	if(b201==1){sm_outs = sm_outs |1;}			// b201
	sm_outs = sm_outs << 1;		
	if(b102==1){sm_outs = sm_outs |1;}			// b102
	sm_outs = sm_outs << 1;		
	if(b101==1){sm_outs = sm_outs |1;}			// b101

    
    // при изменении по SM01 посылаем в CAN
    if(sm_outs != msm_outs  ||  sm_position != msm_position){
		int  _id=60;
		char _b1=dm1_outs;
		char _b2= sm_position / 100 ;
		char _b3= (sm_position - _b2*100) / 10  ;
		char _b4= (sm_position - _b2*100 - _b3*10)  ;
		can_save_wr(_id,_b1,_b2,_b3,_b4);
	}
    

}


//----------------------------------------
// формирование  значения  переменных
// в соответствии  с  сигналами на  входах контроллера
// и  принятой по CAN информацией
void read_inputs(){
	// считываем локальные выходы ПЛК
    busin=inps;       
    if(busin & 1){ x01=0; }else{ x01=1;}
	if(busin & 2){ x02=0; }else{ x02=1;}
	if(busin & 4){ x03=0; }else{ x03=1;}
	if(busin & 8){ x04=0; }else{ x04=1;}
	if(busin & 16){ x05=0; }else{ x05=1;}
	if(busin & 32){ x06=0; }else{ x06=1;}
	if(busin & 64){ x07=0; }else{ x07=1;}
	if(busin & 128){ x08=0; }else{ x08=1;}
	if(busin & 256){ x09=0; }else{ x09=1;}
	if(busin & 512){ x10=0; }else{ x10=1;}
	if(busin & 1024){ x11=0; }else{ x11=1;}
	if(busin & 2048){ x12=0; }else{ x12=1;}
	if(busin & 4096){ x13=0; }else{ x13=1;}
	if(busin & 8192){ x14=0; }else{ x14=1;}
	if(busin & 16384){ x15=0; }else{ x15=1;}
	if(busin & 32768){ x16=0; }else{ x16=1;}
	
	Vin_1 =  aninp1;
    Vin_2 =  aninp2;
    Vin_3 =  aninp3;
    Vin_4 =  aninp4;
    
    // проверяем принятые посылки CAN
	int resalt=1;
	while(resalt==1){
		resalt=can_select_rd();
		if(resalt==1){
			
			//  inps from DM ADR=1
			if(r_id==51){
				if( r_b1&1    ){ x101=1; } else { x101=0; }
				if((r_b1>>1)&1){ x102=1; } else { x102=0; }
				if((r_b1>>2)&1){ x103=1; } else { x103=0; }
				if((r_b1>>3)&1){ x104=1; } else { x104=0; }
				if((r_b1>>4)&1){ x105=1; } else { x105=0; }
				if((r_b1>>5)&1){ x106=1; } else { x106=0; }
				if((r_b1>>6)&1){ x107=1; } else { x107=0; }
				if((r_b1>>7)&1){ x108=1; } else { x108=0; }
			}
			
			//  inps from DM ADR=2
			if(r_id==52){
				if( r_b1&1    ){ x201=1; } else { x201=0; }
				if((r_b1>>1)&1){ x202=1; } else { x202=0; }
				if((r_b1>>2)&1){ x203=1; } else { x203=0; }
				if((r_b1>>3)&1){ x204=1; } else { x204=0; }
				if((r_b1>>4)&1){ x205=1; } else { x205=0; }
				if((r_b1>>5)&1){ x206=1; } else { x206=0; }
				if((r_b1>>6)&1){ x207=1; } else { x207=0; }
				if((r_b1>>7)&1){ x208=1; } else { x208=0; }
			}
			
			//  inps from DM ADR=3
			if(r_id==53){
				if( r_b1&1    ){ x301=1; } else { x301=0; }
				if((r_b1>>1)&1){ x302=1; } else { x302=0; }
				if((r_b1>>2)&1){ x303=1; } else { x303=0; }
				if((r_b1>>3)&1){ x304=1; } else { x304=0; }
				if((r_b1>>4)&1){ x305=1; } else { x305=0; }
				if((r_b1>>5)&1){ x306=1; } else { x306=0; }
				if((r_b1>>6)&1){ x307=1; } else { x307=0; }
				if((r_b1>>7)&1){ x308=1; } else { x308=0; }
			}
			
			//  inps from DM ADR=4
			if(r_id==54){
				if( r_b1&1    ){ x401=1; } else { x401=0; }
				if((r_b1>>1)&1){ x402=1; } else { x402=0; }
				if((r_b1>>2)&1){ x403=1; } else { x403=0; }
				if((r_b1>>3)&1){ x404=1; } else { x404=0; }
				if((r_b1>>4)&1){ x405=1; } else { x405=0; }
				if((r_b1>>5)&1){ x406=1; } else { x406=0; }
				if((r_b1>>6)&1){ x407=1; } else { x407=0; }
				if((r_b1>>7)&1){ x408=1; } else { x408=0; }
			}
			
			//  inps from SM ADR=1
			if(r_id==61){
				if(r_b1 & 4) { a101=1; } else{ a101=0; }
				if(r_b1 & 8) { a102=1; } else{ a102=0; }
				if(r_b1 & 16){ a103=1; } else{ a103=0; }
				if(r_b1 & 32){ a104=1; } else{ a104=0; }
				if(r_b1 & 64){  sm1_mov=1; }  else{ sm1_mov=0; }
				if(r_b1 & 128){ sm1_alr=1; }  else{ sm1_alr=0; }
				sm1_pos = r_b2*100+r_b3*10+r_b4;
			}
			
			//  inps from SM ADR=2
			if(r_id==62){
				if(r_b1 & 4) { a201=1; } else{ a201=0; }
				if(r_b1 & 8) { a202=1; } else{ a202=0; }
				if(r_b1 & 16){ a203=1; } else{ a203=0; }
				if(r_b1 & 32){ a204=1; } else{ a204=0; }
				if(r_b1 & 64){  sm2_mov=1; }  else{ sm2_mov=0; }
				if(r_b1 & 128){ sm2_alr=1; }  else{ sm2_alr=0; }
				sm2_pos = r_b2*100+r_b3*10+r_b4;
			}
			
			//  inps from SM ADR=3
			if(r_id==63){
				if(r_b1 & 4) { a301=1; } else{ a301=0; }
				if(r_b1 & 8) { a302=1; } else{ a302=0; }
				if(r_b1 & 16){ a303=1; } else{ a303=0; }
				if(r_b1 & 32){ a304=1; } else{ a304=0; }
				if(r_b1 & 64){  sm3_mov=1; }  else{ sm3_mov=0; }
				if(r_b1 & 128){ sm3_alr=1; }  else{ sm3_alr=0; }
				sm3_pos = r_b2*100+r_b3*10+r_b4;
			}
			
			//  inps from SM ADR=4
			if(r_id==64){
				if(r_b1 & 4) { a401=1; } else{ a401=0; }
				if(r_b1 & 8) { a402=1; } else{ a402=0; }
				if(r_b1 & 16){ a403=1; } else{ a403=0; }
				if(r_b1 & 32){ a404=1; } else{ a404=0; }
				if(r_b1 & 64){  sm4_mov=1; }  else{ sm4_mov=0; }
				if(r_b1 & 128){ sm4_alr=1; }  else{ sm4_alr=0; }
				sm4_pos = r_b2*100+r_b3*10+r_b4;
			}



		}
	}
    
}

//----------------------------------------
//  сохранение значения переменных  для  обработки
//  в  след.цикле  (установка, сброс)
void save_stat(){
	
	mx01=x01;	mx02=x02;	mx03=x03;	mx04=x04;    
	mx05=x05;	mx06=x06;	mx07=x07;	mx08=x08;    
	mx09=x09;	mx10=x10;	mx11=x11;	mx12=x12;    
	mx13=x13;	mx14=x14;	mx15=x15;	mx16=x16;
	my01=y01;	my02=y02;	my03=y03;	my04=y04;    
	my05=y05;	my06=y06;	my07=y07;	my08=y08;  	
	
	mx101=x101;	mx102=x102;	mx103=x103;	mx104=x104;    
	mx105=x105;	mx106=x106;	mx107=x107;	mx108=x108; 
	mx201=x201;	mx202=x202;	mx203=x103;	mx204=x104;    
	mx205=x205;	mx206=x206;	mx207=x107;	mx208=x108;
	mx301=x301;	mx302=x302;	mx303=x303;	mx304=x304;    
	mx305=x305;	mx306=x306;	mx307=x307;	mx308=x308;
	mx401=x401;	mx402=x402;	mx403=x403;	mx404=x404;    
	mx405=x405;	mx406=x406;	mx407=x407;	mx408=x408;
	my101=y101;	my102=y102;	my103=y103;	    
	my104=y104; my105=y105;	my106=y106;	
	my201=y201;	my202=y202;	my203=y203;	    
	my204=y204; my205=y205;	my206=y206;	
	my301=y301;	my302=y302;	my303=y303;	    
	my304=y304; my305=y305;	my306=y306;	
	my401=y401;	my402=y402;	my403=y403;	   
	my404=y404; my405=y405;	my406=y406;	
	
	ma101=a101; ma102=a102; ma103=a103; ma104=a104;
	ma201=a201; ma202=a202; ma203=a203; ma204=a204;
	ma301=a301; ma302=a302; ma303=a303; ma304=a304;
	ma401=a401; ma402=a402; ma403=a403; ma404=a404;
	mb101=b101; mb102=b102; mb201=b201; mb202=b202;
	mb301=b301; mb302=b302; mb401=b401; mb402=b402;
	
	msm_outs=sm_outs;
	msm_position=sm_position;
	
	mdm1_outs=dm1_outs; 
	mdm2_outs=dm2_outs; 
	mdm3_outs=dm3_outs; 
	mdm4_outs=dm4_outs; 
	
	
	
}

//----------------------------------------
//  изменение значения  секундных  и  милисекундных  таймеров 
//  (дискретность 10 мсек)
void timers(){
	
	int i = 10 ;  		// время цикла в 10мсек
	int max1=30000;		// макс. значение  для мсек таймеров (30мин)
	int max2=18000;		// макс. значение для сек  таймеров   (5час)
	
	// timers,  10ms
	if(t_sys<1000){
		t_sys=t_sys+i;
	}else{
		t_sys = 0;
		if(t101<max2){t101=t101+1;}
		if(t102<max2){t102=t102+1;}
		if(t103<max2){t103=t103+1;}
		if(t104<max2){t104=t104+1;}
		if(t105<max2){t105=t105+1;}
		if(t106<max2){t106=t106+1;}
		if(t107<max2){t107=t107+1;}
		if(t108<max2){t108=t108+1;}
		if(t109<max2){t109=t109+1;}
		if(t110<max2){t110=t110+1;}
	}
	
	if(t01<max1){t01=t01+i;}
	if(t02<max1){t02=t02+i;}
	if(t03<max1){t03=t03+i;}
	if(t04<max1){t04=t04+i;}
	if(t05<max1){t05=t05+i;}
	if(t06<max1){t06=t06+i;}
	if(t07<max1){t07=t07+i;}
	if(t08<max1){t08=t08+i;}
	if(t09<max1){t09=t09+i;}
	if(t10<max1){t10=t10+i;}
	
}

//----------------------------------------
// прием  и  отправка  посылок   
// по  CAN  шине
void can_rw()
{
	CANMessage msg_w;     	 
	CANMessage msg_r;
	
	for(int i=0; i<=10; i++){ r_mess_id[i]=0; w_mess_id[i]=0; }
	for(int i=0; i<=40; i++){ r_mess_data[i]=0; w_mess_data[i]=0; }
	
       
	while (true){
		
		// проверяем, если есть новая посылка 
		// то помещаем в очередь  can_save_rd()
		if(can.read(msg_r)){
			int  id = msg_r.id;
			char b1 = msg_r.data[0];
			char b2 = msg_r.data[1];
			char b3 = msg_r.data[2];
			char b4 = msg_r.data[3];
			can_save_rd(id,b1,b2,b3,b4);
			led_b = !led_b;
		}

		
		// проверяем очередь на отправку  can_select_wr()
		// и если есть , то отправляем  
		if(can_select_wr()){
			msg_w.len = 4;
			msg_w.id 	  = w_id;	
			msg_w.data[0] = w_b1;
			msg_w.data[1] = w_b2;
			msg_w.data[2] = w_b3;
			msg_w.data[3] = w_b4;
			can.write(msg_w);
			
			if(can.tderror()){ led_b = !led_b; w_alr=1; } else { w_alr=0; }
			
		}
		
		
		Thread::wait(2);
	}
        
}

//----------------------------------------
// посимвольный прием из USB и  сохранение  
// информации в буфере, обрабатывается после того как все принято
void pc_rd()
{
	sprintf(pc_buffer, "buff_ok");
	while(1) 
	{
		if( pc.readable() )
		{
			pc_buffer[pc_i] = pc.getc();
			if(pc_i<MAX_SERL){pc_i++; }
			pc_buffer[pc_i]=0; 
		}
	}
}

//----------------------------------------
// поиск и чтение  значения  из  строки 
// возвращает целое число. 
int   read_val() {
	char  	inp_c[10];
	int   	val=0;
	int   	i=0;
	int   	p=0;
	
	while(p<MAX_SERL){	
		if(pc_buffer[p]=='='){ break ; }
		p++; 
	}
	
	p++;
	i=0; if(pc_buffer[p+i]>=48 && pc_buffer[p+i]<=57){ inp_c[i]=pc_buffer[p+i]; } else {inp_c[i]=0 ; }
	i=1; if(pc_buffer[p+i]>=48 && pc_buffer[p+i]<=57){ inp_c[i]=pc_buffer[p+i]; } else {inp_c[i]=0 ; }
	i=2; if(pc_buffer[p+i]>=48 && pc_buffer[p+i]<=57){ inp_c[i]=pc_buffer[p+i]; } else {inp_c[i]=0 ; }
	i=3; if(pc_buffer[p+i]>=48 && pc_buffer[p+i]<=57){ inp_c[i]=pc_buffer[p+i]; } else {inp_c[i]=0 ; }
	i=4; if(pc_buffer[p+i]>=48 && pc_buffer[p+i]<=57){ inp_c[i]=pc_buffer[p+i]; } else {inp_c[i]=0 ; }
	i=5; if(pc_buffer[p+i]>=48 && pc_buffer[p+i]<=57){ inp_c[i]=pc_buffer[p+i]; } else {inp_c[i]=0 ; }
	inp_c[6]=0 ;
	
	val = atoi(inp_c);
	return  val;
}














