#include "mbed.h"
// Simple program allowing user to send messages from mbed COM out through UART to another UART COM.
// Updated 2016/12/20 Hiroaki Okoshi
// Target Board NUCLEO_F446RE
 
Serial pc(USBTX, USBRX,921600); // tx, rx // 9600 ではタイミング衝突し取りこぼす。
Serial uart3 (PB_10, PC_5,57600);
Serial uart4 (PA_0, PA_1,9600); 
Serial uart5 (PC_12, PD_2,9600);
Serial uart6 (PC_6, PC_7,57600);

DigitalOut led1(LED1);
        
char* PARSE_TRIGGERS = "\n";
int PARSE_TRIGGERS_LENGTH = 1;
int MAX_BUFFER_SIZE = 128;

bool isTriggerChar(char c);

int main() {
    char buffer5[MAX_BUFFER_SIZE],buffer6[MAX_BUFFER_SIZE];
      
    int pos5 = 0,pos6 = 0;
    char thisChar = 0;
    bool u3_flag=false,u4_flag=false;
    
    set_time(1481508000);  // Set RTC time to Wed, 28 Oct 2009 11:35:37
                           // http://exp777.cs.land.to/epochsec.html
               
    pc.printf("UART Monitor Start\r\n");
               
    while(true) {
        time_t seconds = time(NULL);
        struct tm *t = localtime(&seconds);
/*
        // CPU 57600bps Port
        if (uart3.readable()) {
            if (u3_flag){
                pc.printf("%02d:%02d|",t->tm_min, t->tm_sec);
                pc.printf("U3(CPU:57600)|");
                u3_flag=false;
            }
            //printf("%s", ctime(&seconds));
            thisChar = uart3.getc();
            pc.printf("%2.2X|", thisChar);

            // buffer3[pos3++] = thisChar;
            // //If trigger or buffer overflow, output and reset buffer...
            // if(pos3 >= MAX_BUFFER_SIZE || isTriggerChar(thisChar)) {
            //    pc.printf("U3:%.*s", pos3, buffer3);
            //    pos3 = 0;
            // }
        }
 */
         // CPU 9600bps Port
        if (uart4.readable()) {
            if (u4_flag){
                pc.printf("%02d:%02d|",t->tm_min, t->tm_sec);
                pc.printf("U4(CPU:9600)|");
                u4_flag=false;
            }
            //printf("%s", ctime(&seconds));
            thisChar = uart4.getc();
            pc.printf("%2.2X|", thisChar);
            
            // buffer4[pos4++] = thisChar;
            // //If trigger or buffer overflow, output and reset buffer...
            // if(pos4 >= MAX_BUFFER_SIZE || isTriggerChar(thisChar)) {
            //     printf( "\r\n");
            //     pc.printf("%02d:%02d|",t->tm_min, t->tm_sec);
            //     pc.printf("U4|%.*s", pos4, buffer4);
            //     pos4 = 0;
            // }
        }
        
         // M8Q 9600bps Port 
        if (uart5.readable()) {
            thisChar = uart5.getc();
            // printf("U5[%2.2X]%c\r\n",thisChar,thisChar );
            buffer5[pos5++] = thisChar;
            //If trigger or buffer overflow, output and reset buffer...
            if(pos5 >= MAX_BUFFER_SIZE || isTriggerChar(thisChar)) {
                printf( "\r\n");
                pc.printf("%02d:%02d|",t->tm_min, t->tm_sec);
                pc.printf("U5(M8Q:9600):%.*s", pos5, buffer5);
                pos5 = 0;
                u3_flag = u4_flag = true;
            }
        }
        
         // M8Q 57600bps Port 
        if (uart6.readable()) {
            thisChar = uart6.getc();
            buffer6[pos6++] = thisChar;
            //If trigger or buffer overflow, output and reset buffer...
            if(pos6 >= MAX_BUFFER_SIZE || isTriggerChar(thisChar)) {
                printf( "\r\n");
                pc.printf("%02d:%02d|",t->tm_min, t->tm_sec);
                pc.printf("U6(M8Q:57600):%.*s", pos6, buffer6);
                pos6 = 0;
                u3_flag = u4_flag = true;
            }
        }    
 
        led1 = !led1;            
    }
}

bool isTriggerChar(char c) {
    for (int i = 0; i < PARSE_TRIGGERS_LENGTH; i++) {
        if(c == PARSE_TRIGGERS[i]) {
            return true;
        }
    }
    return false;
}
