#include "mbed.h"
#include "TinyGPSPlus.h"

#define TX0 P2_14
#define RX0 P2_15
#define TX5 P8_13
#define RX5 P8_11
#define GPSBaud 9600
#define Serial0Baud 115200

Serial Serial0(TX0, RX0);
Serial GPSSerial(TX5, RX5);

TinyGPSPlus tgps;

void displayInfo(void);

int i = 0;


int main(void) {
    
    // setup
    GPSSerial.baud(GPSBaud);
    wait(0.001);
    Serial0.baud(Serial0Baud);
    wait(0.001);

    Serial0.printf("\r\nExample\r\n");
    Serial0.printf("A simple demonstration of TinyGPS++ with an attached GPS module\r\n");
    Serial0.printf("Testing TinyGPS++ library v. ");
    Serial0.printf("%d\r\n", TinyGPSPlus::libraryVersion());
    Serial0.printf("Originally by Mikal Hart, ported to mbed by Kalevi Anders\r\n");
    Serial0.printf("\r\n");

    while(1) {
      while(1) {

        if (tgps.encode(GPSSerial.getc()))
        {
            displayInfo();
            wait(0.1); //little delay to prevent double writing
        }

        if (millis() > 5000 && tgps.charsProcessed() < 10)
        {
            Serial0.printf("No GPS detected: check wiring.\r\n");
//            while(true);
            break;
        }


      }
      Serial0.printf("%d\r\n",i);
      i++;
      wait(1.0);
    }
}

void displayInfo(void)
{
  Serial0.printf("Location: "); 
  if (tgps.location.isValid())
  {
    Serial0.printf("%3.6f, %3.6f", tgps.location.lat(), tgps.location.lng());
  }
  else
  {
    Serial0.printf("INVALID");
  }

  Serial0.printf(" - Date/Time: ");
  if (tgps.date.isValid())
  {
    Serial0.printf("%d/", tgps.date.year());
    if (tgps.date.month() < 10) Serial0.printf("0");
    Serial0.printf("%d/", tgps.date.month());
    if (tgps.date.day() < 10) Serial0.printf("0");
    Serial0.printf("%d", tgps.date.day());
  }
  else
  {
    Serial0.printf("INVALID");
  }

  Serial0.printf(" ");
  if (tgps.time.isValid())
  {
    if (tgps.time.hour() < 10) Serial0.printf("0");
    Serial0.printf("%d:", tgps.time.hour());
    if (tgps.time.minute() < 10) Serial0.printf("0");
    Serial0.printf("%d:", tgps.time.minute());
    if (tgps.time.second() < 10) Serial0.printf("0");
    Serial0.printf("%d\r\n", tgps.time.second());
  }
  else
  {
    Serial0.printf("INVALID\r\n");
  }
}