#include "mbed.h"
#include "Ticker.h"


#define marker 43.0            //Anzahl der Messtreifen pro Umdrehung

//***************************************************************************************************
//Outputs



DigitalOut led4(LED4);      /* Die LED blinkt immer dann auf wenn ein Messpunkt erkannt wurde*/



//***************************************************************************************************
//Inputs

InterruptIn input(p17);     /* Der Eingang p17 des Mikrocontrollers wird als Interrupt definiert, was bedeutet, dass 
                                jedes Mal wenn das Signal ansteigt oder absinkt das Programm unterbrochen wird und eine definierte 
                                Funktion ausgeführt wird 
                                Anmerkung: Die durch den Interrupt ausgelöste Funktion rechnerisch nicht zu aufwändig sein (zB. 
                                printf) sonst hängt sich der Mikrocontroller auf */



//***************************************************************************************************
//Communication



//***************************************************************************************************
//Variables



volatile float rpm = 0, rpm_total;      // Angabe der Umdrehungen pro Minute mit(rpm) und ohne Glättung (rpm_total)

int detekt = 0;                         // Variable zum Umschalten der LED

bool broadcast = false;                 // Durch Aktivieren der Variable wird die Übertragung aktiviert

int sampleCounts = 0, sampleCounts_old = 0;     // Anzahl der Messpunkte pro festgelegter Zeiteinheit

Serial pc(USBTX, USBRX);                // PC Übertragung für Labview


//***************************************************************************************************
//Misc



Ticker serial_tx;                       //Definition des Tickers 

int seconds = 0;                        // Der Ersatz für den Timer

void rpm_counter()
{                                       //Funktion die durch den Interrupt ausgelöst wird,
   sampleCounts++;                      // Zählt die smmpleCounts um 1 nach oben
}






void do_ticker()
{
   broadcast = 1;                       //Diese Funktion wird durch den Ticker aktiviert, also in einem festgelegten
   seconds++;                           // Zeitintervall ausgeführt. Hier wird die Übertragung aktiviert und die Timervariable
}                                       // um das festgelegte Tickerintervall hochgezählt (hier 1)

  




int main(void)
{

   input.rise(&rpm_counter);        // Aktiverung der Interruptfunktion wenn ein Messpunkt erkannt wird (steigende Flanke)

   serial_tx.attach(&do_ticker,1); // Aktivierung des Tickers bei Programmstart, hier wird das Zeitintervall festgelegt (hier ein Sekunde)
    
 

                  seconds = 0;          
                  pc.printf("Beginn der Drehzahlaufzeichnung\n\r"); // Ausgabe an den PC zu Beginn der Messung
   while(true) {

                if(broadcast == 1)                      // Aktivierung der Übertragung für dieses Zeitintervall
                 {
                  rpm_total = sampleCounts/marker;      // Errechnung der Umdrehungen

                  rpm = ((rpm*1) + ((sampleCounts - sampleCounts_old)/ marker * 60))/2; //Errechnung der geglätteten Drehzahl in U/min. Glättungsfaktor 
                                                                                        // einstellbar durch das Verhältnis von alter zu neuer Drehzahl (hier 1:1)
                  sampleCounts_old = sampleCounts;
                     
                  pc.printf("$1;1;%i;%f;0\r\n",seconds,rpm);                //Ausgabe der aktuellen Messwerte an den PC
                  broadcast = 0;                                            // Ende der Aufzeichnung für dieses Zeitintervall
                 }
                if  (detekt != sampleCounts) {led4 = !led4; detekt = sampleCounts;}; //Funktion zum Umschalten der LED bei Messpunkterkennung

               }
}
