#ifndef _SDCARD_ 
#define _SDCARD_  
#include "mbed.h" 
#include "SDBlockDevice.h" 
#include "FATFileSystem.h" 
#include "sample_hardware.hpp" 

  

class SDcard 

{     

    private: 
     float temp;       //current temperature of sensor 
     float pressure;  //current pressure of sensor 
     float fLDR;      //current light level from LDR 

      void update_temp(double t) //use this function to update the current temperature value 
            { 
                temp = t; 
            }  

        void update_pressure(double p) //use this function to update the current pressure value 
            { 
                pressure = p;     
            }  

        void update_LDR(double L) 
            { 
                fLDR = L;    
            } 

        

    public: 
    EventQueue SDcard_Queue; 
    
    SDcard()
        {                      //constructor, 
  
    }    

   

      ~SDcard(){                      //Deconstructor,  

    }


        void getSerial2SD() // Queue Consumer
        {
            if (!Serial2SD.empty())
            {
                osEvent evt = Serial2SD.get(); 
        switch (evt.status) 
                {
                    case osEventMail:
                //Normal status
                                SD_message *mail = (SD_message*)evt.value.p;
                                // Pass onto a decoder/ handler
                                // i.e. InputHandler(message) // Will inspect the difference parameters in the structure and proceed accordingly
                                Serial2SD.free(mail);   // Free up the space in the memory Pool
                    default:
                //All other errors (see cmsis_os.h for meaning of error code)
                //printf("Serial2Net->get() returned %02x status\n\r", evt.status);
                }               
            }
        }

      void update_sensor_info(sample_message msg) //updates all current sensor information, this is called by a ticker every 5 seconds to read from the mailbox 
    { 
         update_temp(msg.temp);                  // Include message class passing of data 
         update_pressure(msg.pressure); 
         update_LDR(msg.ldr); 
    } 
    



    void Save_Data() {          
    //Create a filing system for SD Card 

                        // initalising the SD card 
            if ( sd.init() != 0) {
                    printf("Init failed \n");
                    //errorCode(FATAL);
            }  
            
    FATFileSystem fs("sd", &sd);
        
    FILE* fp = fopen("/sd/SensorData.csv","a");

    if (fp == NULL) {
        error("Could not open file for write\n");
        //errorCode(FATAL);
    } 

    //Storing sensor data in csv file 

    fprintf(fp, " Temperature(C) , %4.2f , Pressure(mbar) , %4.2f , Lux , %4.2f \n", temp , pressure , fLDR );

    //Close the file
    fclose(fp); 

   //Close down SD card 
    sd.deinit(); 
    
    //errorCode(OK);
  
        
   } 
}; 
// creating the instance SD of the class SDcard 


SDcard m_oSD; 

#endif