#include "mbed.h"
#include "mbed_events.h"
#include <string> 
#include <iostream>
#include <vector>

#define ERROR_LCD_EXIT 1
#define ERROR_SERIAL_EXIT 2
#define ERROR_SD_EXIT 3
#define ERROR_NET_EXIT 4
#define ERROR_SAMPLER_EXIT 5
#define cmdRow 36
#define cmdCol 37

Serial pc(USBTX, USBRX);   // USB Tx and Rx Connections 

const int buffer_size = 30;
char rx_buffer[buffer_size+1];

Queue<uint32_t,5> Serial2Sampler;           // Serial -> Sampler Message Queue. 5 Elements Wide
Mail<SD_message, 5> Serial2SD;                  // Serial -> SD Mailbox  Time&Date + Sample Management

class Serialcomms
{
   private:
         float fTemp;               //current temperature of sensor
         float fPressure;           //current pressure of sensor
         float fLDR;                //current light level from LDR
                 bool Logging;
                 bool SampleEN;
         vector<int> ErrorCodes;
         int rx_in; 
         int cmdCount;
         int rxInputFlag;
         char RxIn[buffer_size+1];
         char clearingArray[buffer_size+1];
         char timestampArray[15+1];
         
   public:
        EventQueue SERIAL_Queue;                    //Initialise the EventQueue
     
                void addtoSerial2Sampler(uint32_t Data)         // Producer for the Queue
                {
                    osStatus Stat = Serial2Sampler.put((uint32_t*)Data);    // Put the data into the message queue
                    if (Stat == osErrorResource)    // Try catch & Error Handling
                    {
                        printf("Serial2Sampler->put() Error code: %4Xh, Resource not available\r\n", Stat);
                    }
                }    

                void addtoSerial2Net()          // Producer for the Mailbox
                {
            time_and_date *mail = Serial2Net.alloc();       // Allocatte space in the memory pool
                    mail -> current_time = timestampArray;
                    osStatus Stat = Serial2Net.put(mail);               // Pointer to teh data package
                    if (Stat == osErrorResource)                                // Try catch & Error Handling
                    {
                        printf("Serial2Net->put() Error code: %4Xh, Resource not available\r\n", Stat);
                    }
                }    

                void addtoSerial2LCD()          // Producer for the Mailbox
                {
                    time_and_date *mail = Serial2Net.alloc();
                    mail -> current_time = timestampArray;
                    osStatus Stat = Serial2LCD.put(mail);   // Put the data into the message queue
                    if (Stat == osErrorResource)    // Try catch & Error Handling
                    {
                        printf("Serial2LCD->put() Error code: %4Xh, Resource not available\r\n", Stat);
                    }
                }    
                
        void displayFrame()
        {
            printf("\033[2J"); // Clear screen
            printf("\033[0;0H"); // Home Positon Reset
            printf("*********************************************************************************\n"
                   "*                    ELEC351 COURSEWORK ENVIRONMENTAL SYSTEM                    *\n"
                   "*********************************************************************************\n"
                   "*        Sensor Readout         *                     Terminal                  *\n"
                   "*********************************************************************************\n"
                   "* Timestamp:                    *                                               *\n" // Col 5 Row 13
                   "* Temperature:                  *                                               *\n" // Col 6 Row 15
                   "* Pressure:                     *                                               *\n" // Col 7 Row 12
                   "* Light Level:                  *                                               *\n" // Col 8 Row15
                   "*********************************                                               *\n"
                   "*         Error Codes           *                                               *\n" // Col 10                  
                   "*********************************                                               *\n" // Col 11 Row 2
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*********************************                                               *\n"
                   "*         Thread Health         *                                               *\n"
                   "*********************************                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n" 
                   "*                               *                                               *\n"    // cmd position r:36 c:37 
                   "*********************************************************************************\n\n"    
                   );          
            printf("\033[%d;%dfcmd: ", cmdRow, cmdCol);
        }  
        
        Serialcomms() // Take the reference of the sampler object and state in m_oSamplerRef
        {
            pc.baud(9600);
            rx_in = 0;
            cmdCount = 0;
            fTemp = 0;
            fPressure = 0;
            fLDR = 0;
                      Logging = 0;
                      SampleEN = 0;
            for (int i = 0; i < buffer_size+1; i++)
            {
                clearingArray[i] = ' ';
                rx_buffer[i] = 0;
                                if (i < 16)
                                {
                                    timestampArray[i] = ' ';
                                }

            }
                        timestampArray[8] = ':';
            displayFrame();
            SERIAL_Queue.call_every(1000, callback(this, &Serialcomms::updateTerminal));
            SERIAL_Queue.call_every(50, callback(this, &Serialcomms::ReadData));           // Start the periodic event to check the serial buffer
        }
        
        ~Serialcomms()
        {
            printf("Closing Serial Comms.");
        }  
        
        void setsampledata(sample_message msg)      // Update internal values
        {
                    fTemp = msg.temp;
                    fPressure = msg.pressure;
                    fLDR = msg.ldr;   
        }
        
        sample_message getsampledata()              // Retrieves the data
        {
            sample_message msg;
            msg.temp = fTemp;
            msg.pressure = fPressure;
            msg.ldr = fLDR;
            return msg;
        }
        
        void updateTerminal()                   // Print internal values of sensors
        {          
            printf("\033[6;16f%s", timestampArray);  
            printf("\033[7;16f%5.2f", fTemp);
            printf("\033[8;16f%5.2f", fPressure);
            printf("\033[9;16f%5.2f", fLDR);
            if (ErrorCodes.size() == 0)
            {
                printf("\033[13;3fNo Error Codes Raised\n");
            }
            else
            {
             for (int idx = 0; idx < ErrorCodes.size(); idx++)
             {
                printf("\033[%d;3: %d\n",(11+idx),ErrorCodes[idx]);                    
             }
            }
            // Add code to receive feedback from watchdog and place into thread safe section
        }
 
         
        void printstringtoTerminal(char Data[])
        {
            printf("\033[%d;%df%s", (cmdRow-(cmdCount+1)),(cmdCol+5), Data);  // Confirmation of Command
            cmdCount++; 
        }
        void printintegertoTerminal(int Data)
        {
            printf("\033[%d;%df%d", (cmdRow-(cmdCount+1)),(cmdCol+5), Data);  // Confirmation of Command   
            cmdCount++;              
        }
        
        int searchInput(char stream[], char command[])
        {
            int match = 0;
            const int commandLength = strlen(command); 
            for (int i = 0; i < commandLength; i++)
            {
                if  (stream[i] == command[i])
                {
                    match = i;              // Return the position of the last command character
                }
                else
                {
                    match = 0;
                    i = commandLength-1;
                }
            }           
            return match;
        }
        

        void handleInput()
        {   
            if (int readall = searchInput(RxIn, "READ ALL") > 0)     
            {
              printstringtoTerminal("READING ALL");                         
            }
                        
            else if(int readall = searchInput(RxIn, "DELETE ALL") > 0)
            {
                printf("\033[%d;%df%s", (cmdRow-(cmdCount+1)),(cmdCol+5), "DELETING ALL");  // Confirmation of Command
                cmdCount++;
            }           
            else if(int read = searchInput(RxIn, "READ") > 0)
            {
                read = searchInput(RxIn, "READ");
                char count[buffer_size] = {0};
                for (int i = read; i < strlen(RxIn); i++)
                {
                    count[i-read] = RxIn[i+1];
                }
            }
            else if(int del = searchInput(RxIn, "DELETE") > 0)
            {
                del = searchInput(RxIn, "DELETE");
                char count[buffer_size] = {0};
                for (int i = del; i < strlen(RxIn); i++)
                {
                    count[i-del] = RxIn[i+1];
                }
            }         
            else if(int setdate = searchInput(RxIn, "SETDATE") > 0) //<dd> <mm> <yyyy>
            {
                setdate = searchInput(RxIn, "SETDATE"); // Returns the index of the last character
                char count[buffer_size] = {0};
                for (int i = setdate; i < strlen(RxIn); i++)
                {
                                    if (RxIn[i+1] != ' ')
                                    {
                    count[i-setdate] = RxIn[i+1];
                    timestampArray[i-setdate] = RxIn[i+1];                                      
                                    }
                }
                                addtoSerial2LCD();      // Update the DATE on the LCD
                                addtoSerial2Net();      // Update the DATE on the Webpage
            }     
            else if(int settime = searchInput(RxIn, "SETTIME") > 0) //<hh> <mm> <ss>
            {
                settime = searchInput(RxIn, "SETTIME");
                char count[buffer_size] = {0};
                for (int i = settime; i < strlen(RxIn); i++)
                                {
                                    if (RxIn[i+1] != ' ')
                                    {
                    count[i-settime] = RxIn[i+1];
                    timestampArray[i-settime+9] = RxIn[i+1];
                                    }
                }
                                addtoSerial2LCD();      // Update the TIME on the LCD
                                addtoSerial2Net();      // Update the TIME on the Webpage                               
            }        
            else if(int sett = searchInput(RxIn, "STATE") > 0)
            {
                            SampleEN = !SampleEN;
                            if (SampleEN)
                            {
                                printstringtoTerminal("SAMPLING");                          
                            }
                            else
                            {
                                printstringtoTerminal("SAMPLING DISABLED");                         
                            }
                            addtoSerial2Sampler(SampleEN);
//                          uint32_t bit = (uint32_t)(RxIn[5] - '0');   // Take the last character after the "SETT" string and push it onto the queue
//                          if ((bit == 1) || (bit == 0))
//                          {
//                              addtoSerial2Sampler(bit);
//                          }
//                          else
//                          {
//                              printf("Invalid STATE Entry");
//                          }
            }
            else if(int state = searchInput(RxIn, "SETT") > 0)     // PENDING WORK -> Set the time period of sampling  
            {
                            uint32_t bit = 0;   // Re-init
                            bit += (uint32_t)(RxIn[4] - '0');   // Take the last character after the "SETT" string and push it onto the queue
                            // Modify the enable sampling bit
                            if (bit > 0)
                            {
                                addtoSerial2Sampler(bit);
                            }
            }     
            else if(int logging = searchInput(RxIn, "LOGGING") > 0)     // Verbose logging
            {
                            Logging = !Logging; // Toggle the private Logging Bool Variable
                            if (Logging)
                            {
                                printstringtoTerminal("LOGGING");                           
                            }
                            else
                            {
                                printstringtoTerminal("LOGGING DISABLED");                          
                            }
            }
            else if(int clearall = searchInput(RxIn, "CLEARALL") > 0)   // Reset the terminal
            {
                cmdCount = 0;
                for (int i = 0; i < 22; i++)
                {
                    printstringtoTerminal(clearingArray);
                }
                                displayFrame();
                cmdCount = 0;
            }
            else
            {
                printstringtoTerminal("UNKNOWN COMMAND");
            }

            for (int i = 0; i < (buffer_size+1); i++)   // Init
            {
                RxIn[i] = 0;   
                              rx_buffer[i] = ' ';
            }
            printf("\033[%d;%dfcmd: %s", cmdRow, cmdCol, rx_buffer);  // Reset to cmd location      
        }
 

        void ReadData()
        {
            while(pc.readable())                // While there's data in the Rx buffer
            {
                char c = pc.getc();             // Take a character off the buffer
                if (c == 0x0D)                  // Enter ASCII Code
                {
                    printf("\033[%d;%df%s", (cmdRow-(cmdCount+1)),(cmdCol+5), rx_buffer);     // Echo the Command back to the terminal
                    rx_in = 0;                  // Reset the buffer indexer
                    int stringLength = strlen(rx_buffer); //finds length of the array
                    for (int i = 0; i < stringLength; i++) {
                        RxIn[i] = rx_buffer[i]; // Copies buffer into global // stringLength-1-i
                    }
                    RxIn[stringLength] = '\0'; //adds NULL character
                    SERIAL_Queue.call(callback(this, &Serialcomms::handleInput));
                    
                    for (int i = 0 ; i < stringLength; i++)
                    {
                        rx_buffer[i] = 0;       // Clear the buffer with spaces
                    }
                    printf("\033[%d;%df%s", cmdRow, (cmdCol+5), clearingArray);                 // Clear the Command entry space
                    //printf("\033[%d;%df%s", (cmdRow -(cmdCount+2)), cmdCol,  clearingArray);  // Clear above the oldest record Command

                    if (cmdCount >= 20)
                    {
                        cmdCount = 0;
                    }
                    cmdCount++;

                    break;
                }
                rx_buffer[rx_in] = c;
                printf("\033[%d;%df%s",cmdRow, (cmdCol+5), rx_buffer);  // Echo     
                rx_in += 1;    // Increase received indexer
            }
        }

        void updateErrors(vector<int> ErrorsIn)
        {
            for (int idx = 0; idx < ErrorsIn.size() ; idx++)    // Add the Error Codes to the vector
            {
                ErrorCodes.push_back(ErrorsIn[idx]);
            }
        }
        void updateTimeDate()
        {   
        }   
};

