#ifndef _SAMPLER_
#define _SAMPLER_

#include "mbed.h"
#include "LCD.hpp"
#include "SerialComms.hpp"
#include "SDcard.hpp"
#include "sample_hardware.hpp"
#include <vector>
#define Activate_Flag 1

Serialcomms m_oSerial;

class Sampler
{
private:
    int SampleEN;
    sample_message message;
   
public: 
    EventQueue SAMP_Queue;                  //Initialise the EventQueue

    Sampler()   //Constructor 
    {
        SampleEN = 0;
    }
    ~Sampler() //Destructor - should the instance go out of scope, this is called
    {
            
    }
 
        void getSerial2Sampler()    // Queue Consumer
        {
            if (!Serial2Sampler.empty())
            {
                osEvent evt = Serial2Sampler.get();     //With timeout
        switch (evt.status) 
                {
            case osEventMessage:
                //Normal status
                                if ((evt.value.v == 0) || (evt.value.v == 1))   // Update the enable pin if the value co-responds to allowed cases
                                {
                                    SampleEN = evt.value.v;             
                                }
                greenLED = !greenLED;
            case osEventTimeout:
                //Timeout
                //printf("Serial2Sampler->get() returned %02x status (timeout)\n\r", evt.status);
            default:
                //All other errors (see cmsis_os.h for meaning of error code)
                //printf("Serial2Sampler->get() returned %02x status\n\r", evt.status);
                }               
            }
        }


    void getData()
    {
        float temp = sensor.getTemperature();
        float pressure = sensor.getPressure();
        float LDR = adcIn.read()*4095;
        #ifdef BME
        float humidity = sensor.getHumidity();
        #endif
        sample_message msg; // Define instance of message structure
        msg.temp = temp;
        msg.pressure = pressure;
        msg.ldr = LDR;
        message = msg;  // Write to the private 'global' variable
    }
        
    void publishSample()
    {
       if (SampleEN == 1)
       {
          getData();
          m_oDisplay.LCD_Queue.call(&m_oDisplay, &LCD_Data::update_sensor_info, message);
                  m_oNet.Network_Queue.call(&m_oNet, &Network::update_sensor_info, message);
          m_oSerial.SERIAL_Queue.call(&m_oSerial, &Serialcomms::setsampledata, message);
                  //m_oSD.SDcard_Queue.call(&m_oSD, &SDcard::update_sensor_info, message);
        }
    }
   

    void updateTimeData();
};

#endif


Sampler m_oSample;

