#include "mbed.h"
#include "sample_hardware.hpp"
#include "Sampler.hpp"
#define WatchDogTimeout 2000
#define SerialRxFlag 1

Thread tLCD, tSAMP, tSERIAL, tSD, tNET;

//Watchdog Initialisation - Implement Custom to only reset the thread which is faulty. Include a top level Watchdog to reset everything in Main
//Watchdog_RTOS SerialWatch;
//Watchdog_RTOS SampleWatch;
//Watchdog_RTOS LCDWatch;
//Watchdog_RTOS SDWatch;
//Watchdog_RTOS NetWatch;

void LCD_Thread()
{   
    vector<int> ErrorCodes;
   // LCDWatch.kick(WatchDogTimeout);
    while(1)
    {
     //   m_oDisplay.LCD_Queue.call_every(1500, LCDWatch.kick);
        m_oDisplay.LCD_Queue.call_every(1000, &m_oDisplay, &LCD_Data::display_LCD);         //Displays the current sensor information onto the LCD screen every x miliseconds
        m_oDisplay.LCD_Queue.call_every(1000, &m_oDisplay, &LCD_Data::getSerial2LCD);       //Displays the current sensor information onto the LCD screen every x miliseconds
                m_oDisplay.LCD_Queue.dispatch();                                                    // Enters WAITING state when blocking 
        ErrorCodes.push_back(ERROR_LCD_EXIT);                                               // Update Error Vector
        m_oSerial.SERIAL_Queue.call(&m_oSerial, &Serialcomms::updateErrors, ErrorCodes);    // Pass error vector to the serial thread
    }
}

void SAMP_Thread()
{
     vector<int> ErrorCodes;
     //SamplerWatch.kick(WatchDogTimeout);
     while(1)
     {
                //m_oSample.SAMP_Queue.call_every(1500, SamplerWatch.kick);
        m_oSample.SAMP_Queue.call_every(500, &m_oSample, &Sampler::publishSample);                      // Publish sample default (0.5 Second Tp)
        m_oSample.SAMP_Queue.call_every(500, &m_oSample, &Sampler::getSerial2Sampler);           // Start the periodic event to check the serial buffer
              m_oSample.SAMP_Queue.dispatch();                                                                // Enters WAITING state when blocking 
        ErrorCodes.push_back(ERROR_SAMPLER_EXIT);                                                            // Update Error Vector
        m_oSerial.SERIAL_Queue.call(&m_oSerial, &Serialcomms::updateErrors, ErrorCodes);     // Pass error vector to the serial thread
     }
}

void SERIAL_Thread()
{
    vector<int> ErrorCodes;
        //SerialWatch.kick(WatchDogTimeout);
     while(1)
     {
        //m_oSerial.SERIAL_Queue.call_every(1500, SerialWatch.kick);
        m_oSerial.SERIAL_Queue.dispatch();                                                               // Enters WAITING state when blocking 
        ErrorCodes.push_back(ERROR_SERIAL_EXIT);                                                            // Update Error Vector
     }   
}


void Network_Thread() 
{ 
    vector<int> ErrorCodes;
    while(1) 
    {
            
        m_oNet.Network_Queue.call_every(5000, &m_oNet, &Network::NetPush); 
        m_oNet.Network_Queue.call_every(1000, &m_oNet, &Network::getSerial2Net);        // Poll the mailbox for an update in time and date
        m_oNet.Network_Queue.dispatch(); 
        ErrorCodes.push_back(ERROR_NET_EXIT);                                                            // Update Error Vector
//        m_oNet.Network_Queue.call(&m_oNet, &Network::updateErrors, ErrorCodes);     // Pass error vector to the serial thread
    }    
} 

void SD_Thread() 
{ 
    while(1) 
    { 
         m_oSD.SDcard_Queue.call_every(5000, &m_oSD, &SDcard::Save_Data); 
         m_oSD.SDcard_Queue.dispatch(); 
    } 
}    

     
int main()
{  
    tLCD.start(LCD_Thread);
    tSAMP.start(SAMP_Thread);
    tSERIAL.start(SERIAL_Thread);
    //tSD.start(SD_Thread);
    tNET.start(Network_Thread);
    Thread::wait(osWaitForever);
}

