
#ifndef TELEMETRY
#define TELEMETRY

//#define DEBUG

#include "mbed.h"
#include "EthernetInterface.h"

/** Ethernet Interface for send/receive Datastructs over udp 
 *
 * By Sebastian Donner
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * @code
 * #include "mbed.h"
 * #include "Telemetry.h"
 *
 * #Telemetry Network;
 * 
 * uint8_t buffer[255];  
 * int     SELF_PORT        = 8889;
 * 
 * typedef struct struct_system
 *  {
 *   struct_test()
 *   :length(9), ID(0)
 *   {}
 *   uint8_t  length              ;//1
 *   uint8_t  ID                  ;//2
 *   uint8_t  flag_bit0      : 1  ;//3.0
 *   uint8_t  flag_bit1      : 1  ;//3.1
 *   uint8_t  flagbyte_2          ;//4 
 *   uint16_t word                ;//6
 *    int16_t counter             ;//8
 *   uint8_t  cs                  ;//9
 *} Tstruct_test;
 *
 *
 * struct_test  test;
 *
 * uint8_t* struct_id[] {
 *                       &test     //ID0
 *                      };
 *                        
 * main
 * {
 *  Network.InitEthernetConnection();
 *  Network.ConnectSocket_udp_send();
 *  Network.ConnectSocket_udp_rec(SELF_PORT);
 *   
 *  while(1) 
 *   {
 *    if (Rec_Struct_UDP(char *buffer))        // receive and CS check       
 *      {
 *       uint8_t* b_pointer;                
 *
 *       b_pointer = struct_id[buffer[1]];     // Pointer to received Struct   
 * 
 *       for(int i = 0; i < (buffer[0]); i++)  // Copy buffer to Struct
 *       {
 *        *b_pointer = buffer[i];
 *         b_pointer++;
 *       }
 *       
 *       b_pointer = struct_id[buffer[1]];     // Pointer to received Struct
 *       
 *       Send_Struct_UDP(Network.input_Host, b_pointer); // Send received Struct back to sender
 *      } 
 *
 *    wait(1);
 *   }        
 * }          
 * 
 * @endcode
 */ 



class Telemetry
{
    public:
        //! Create Ethernet Interface
        Telemetry(PinName orange, PinName green);
        
        DigitalOut orange;
        DigitalOut green;
        
        //! IP Address of mbed Interface
        char* ip_self;

        //! IP Addess and Port of databank Server
        Endpoint db_server;

        //! IP Addess and Port of control Server
        Endpoint controller;

        //! IP Addess and Port of MSG on Server Port
        Endpoint input_Server;
        
        //! IP Addess and Port of MSG on Client Port
        Endpoint input_Client;

        
        #ifdef DEBUG
        void InitUSBSerialConnection();
        #endif

        //! init with DHCP
        bool InitEthernetConnection();

        //! init with Static IP
        bool InitEthernetConnection(const char* IPAdress, const char* SubNetMask, const char* GateWay);


        //! Close Connection
        void CloseEthernetConnection();

        
        //! Connect Port TCP 
        void ConnectSocket_TCP(Endpoint Host);
        
        //! Connect Port for UDP Client  
        void ConnectSocket_UDP_Client();
        
        //! Connect Port for UDP Server
        void ConnectSocket_UDP_Server(int Port);

        
        //! Close Port TCP
        void CloseSocket_TCP();
        
        //! Close Port UDP Client
        void CloseSocket_UDP_Client();
        
        //! Close Port UDP send
        void CloseSocket_UDP_Server();

        
        //! Struct Check Sum calc
        uint8_t do_cs(uint8_t *buffer); 
    
        
        //! Read UDP Packet on Client Port
        int  Rec_Data_UDP_Client(char *buffer, int size);

        //! Read UDP Packet on Server Port
        int  Rec_Data_UDP_Server(char *buffer, int size);
        
        //! Check Packet of containing Struct 
        bool Rec_Struct(uint8_t *buffer);
        
        //! Read TCP Packet
        int  Rec_Data_TCP(char *buffer, int size);

        
        //! Send UDP Packet as Client
        void Send_Data_UDP_Client(Endpoint Server, char* Daten, int size);

        //! Send UDP Packet as Server
        void Send_Data_UDP_Server(Endpoint Client, char* Daten, int size);
                
        //! Send Struct as UDP Client
        void Send_Struct_UDP_Client(Endpoint Server, uint8_t* Daten);
        
        //! Send Struct as UDP Server
        void Send_Struct_UDP_Server(Endpoint Client, uint8_t* Daten);       
       
       
        //! Send TCP Packet
        void Send_Data_TCP(char* Host, char* Daten);
        
        
    private:
        bool InitSucceed;    
        
};

#endif