/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "mbed.h"
#include "USBHost.h"
#include "Utils.h"
#include "FATFileSystem.h"
#include "MassStorage.h"

int MassStorage_ReadCapacity(int device, u32* blockCount, u32* blockSize);
int MassStorage_Read(int device, u32 blockAddr, u32 blockCount, u8* dst, u32 blockSize);
int MassStorage_Write(int device, u32 blockAddr, u32 blockCount, u8* dst, u32 blockSize);

class USBFileSystem : public FATFileSystem, public USBSCSI
{
    //int _device;
    u32 _blockSize;
    u32 _blockCount;
    
public:
    USBFileSystem() : FATFileSystem("usb")/*,_device(0)*/,_blockSize(0),_blockCount(0)
    {
    }
/*    
    void SetDevice(int device, unsigned char in, unsigned char out)
    {
        _device = device;
    }
*/    
    virtual int disk_initialize()
    {
        return SCSIReadCapacity(&_blockCount,&_blockSize);
        //return MassStorage_ReadCapacity(_device,&_blockCount,&_blockSize);
    }
    
    virtual int disk_write(const char *buffer, int block_number)
    {
        return SCSITransfer(block_number, 1,(u8*)buffer,_blockSize,HOST_TO_DEVICE);
        //return MassStorage_Write(_device,block_number,1,(u8*)buffer,_blockSize);
    }
    
    virtual int disk_read(char *buffer, int block_number)
    {
        return SCSITransfer(block_number, 1, (u8*)buffer, _blockSize, DEVICE_TO_HOST);
        //return MassStorage_Read(_device,block_number,1,(u8*)buffer,_blockSize);
    }
        
    virtual int disk_sectors()
    {
        return _blockCount;
    }
};

void DumpFS(int depth, int count)
{
    DIR *d = opendir("/usb");
    if (!d)
    {
        printf("USB file system borked\n");
        return;
    }

    printf("\nDumping root dir\n");
    struct dirent *p;
    for(;;)
    {
        p = readdir(d);
        if (!p)
            break;
        int len = sizeof( dirent);
        printf("%s %d\n", p->d_name, len);
    }
    closedir(d);
}

int OnDiskInsert(int device, unsigned char in, unsigned char out)
{
    USBFileSystem fs;
    fs.SetDevice(device, in, out);
    DumpFS(0,0);
    return 0;
}

/*
    Simple test shell to exercise mouse,keyboard,mass storage and hubs.
    Add 2 15k pulldown resistors between D+/D- and ground, attach a usb socket and have at it.
*/

Serial pc(USBTX, USBRX);
int GetConsoleChar()
{
    if (!pc.readable())
        return -1;
    char c = pc.getc();
    pc.putc(c); // echo
    return c;
}

void TestShell();

#ifdef ROS_MAIN
#include "ros_mbedbt.h"
#include <std_msgs/String.h>

ros::NodeHandle  nh;

std_msgs::String str_msg;
ros::Publisher chatter("chatter", &str_msg);

char hello[13] = "hello world!";

int main() {

    pc.baud(9600);
    
    nh.initNode();
    nh.advertise(chatter);
    while (1) {
        USBLoop();
        wait_ms(100);
        str_msg.data = hello;
        chatter.publish( &str_msg );
        nh.spinOnce();
    }

}

#endif