#include "mbed.h"

Timeout timer;
Ticker ticker;
DigitalOut stepled(LED1);   // Toggles on step
DigitalOut ccled(LED2);     // Counterclockwise, =Dir
DigitalOut correct(LED3);   // Checks if nr. of steps made = equal to index
DigitalOut toggle(LED4);    // Proves life exists

// MS1 MS2 MS3     Microstep Resolution 
// Low Low Low     Full step 
// Hig Low Low     Half step 
// Low Hig Low     Quarter step 
// Hig Hig Low     Eighth step 
// Hig Hig Hig     Sixteenth step 
DigitalOut MS1(p11);
DigitalOut MS2(p12);
DigitalOut MS3(p13);

//Sleep and Reset not connected.
DigitalOut enable(p20);

DigitalOut Step(p21);
DigitalOut Dir(p22);

// Motor has 200 steps per rotation and is driven Sixteenth step in comment.
// So 3200 microsteps per rotation

int accel=30;       // steps/s^2
int speed=32000;    // steps/s  /3200   = 10 Rounds/s *60    = 600RPM
int index=12800;    // steps            = 4 rotations
int count;

void timeout() {
    stepled=!stepled;
    Step=1;                 // Rising edge
    wait_us(5);             // Short high time
    Step=0;
    if(count<(index/2)) {   // Start accelerating untill the top speed is reached
        if(accel*count<speed) {
            timer.attach_us(&timeout,((1000000/((accel*count)+10))-5)); // decreasing time until next step
        }                           // the +10 is to avoid dividing by 0 and boosts initial speed
        else {      // don't go over the top speed
            timer.attach_us(&timeout,((1000000/speed))-5);
        }                           // the -5 is to compensate for the 5us high time :p
    }
    else if(count<index) {  // Halfway to the target, start decelerating
        if(accel*(index-count)<speed) {
            timer.attach_us(&timeout,((1000000/((accel*(index-count))+10))-5)); // increasing time until next stil
        }
        else {      // stay at top speed if needed
            timer.attach_us(&timeout,((1000000/speed))-5); 
        }
    }
    else {          // target reached
        timer.detach();
        stepled=0;
        Step=0;
        if(count==index) {  // Check if the right number of steps were made
            correct=1;
        }
        else {
            correct=0;
        }
    }
    count++;        // ***INC STEPCOUNT***
}
        
void toggler() {    // It toggles
    toggle=!toggle;        
}

int main() {
    // Initialize pololu drive
    enable=0;   // Low active
    MS1=1;      // Sixteenth
    MS2=1;
    MS3=1;
    
    // Initialize for movement
    stepled=0;
    count=0;
    correct=0;
    
    timer.attach(&timeout,1);   // Initiate a movement
    ticker.attach(&toggler,1);  // Toggle the live led on interrupt
    while(1) {
        wait(10); // Simulate some 10sec delay between commands
        
        // Initialize for next movement
        Dir=!Dir;   // Toggle Direction
        ccled=Dir;  // Make it obvious
        count=0;    // Reset count
        correct=0;  // Reset count=index check
        
        timer.attach(&timeout,1);   // Initiate a movement
    }  
}