#include "mbed.h"
#include "CAN.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"

Ticker ticker;      
Serial pc(USBTX, USBRX);
DigitalOut write_activity(LED1); //CAN activity
DigitalOut read_activity(LED2);
DigitalOut pc_activity(LED3);    //USB activity
CAN can1(p9, p10);  // rd, td Transmitter
CAN can2(p30, p29); // rd, td Monitor

int counter = 0;
char candata[8];
char pc_msg[50]; 
CANType pc_type;
CANFormat pc_format;
int pc_ID; //standard 11bit ID
//int pc_IDe; //extended 29 (not used yet)
int pc_length;
int pcd0; int pcd1; int pcd2; int pcd3; int pcd4; int pcd5; int pcd6; int pcd7; //8 bytes data
CANMessage msg;

void setdata(int d0, int d1, int d2, int d3, int d4, int d5, int d6, int d7) {
    candata[0] = (char) (d0); // LSB
    candata[1] = (char) (d1);
    candata[2] = (char) (d2);
    candata[3] = (char) (d3);
    candata[4] = (char) (d4);
    candata[5] = (char) (d5);
    candata[6] = (char) (d6);
    candata[7] = (char) (d7); // MSB
}

void canread() {
    //printf("CANmessage: %c\n", msg);
    pc.printf("Read: [ ID: %d", msg.id);
    pc.printf(" Length: %d", msg.len);
    pc.printf(" Data: %x", msg.data[0]);
    pc.printf(" %x", msg.data[1]);
    pc.printf(" %x", msg.data[2]);
    pc.printf(" %x", msg.data[3]);
    pc.printf(" %x", msg.data[4]);
    pc.printf(" %x", msg.data[5]);
    pc.printf(" %x", msg.data[6]);
    pc.printf(" %x", msg.data[7]);
    pc.printf(" Type: %d", msg.type);
    pc.printf(" Format: %d ]\n", msg.format);
    read_activity = !read_activity;  //Blink!
    can2.reset();
}

void pc_msg_read() {
    // Data to be sent as !<format>_<type>_<ID>_<length>_<d0>_<d1>_<d2>_<d3>_<d4>_<d5>_<d6>_<d7> ("_" = space)
 
    // Read the string and copy it to the char array pc_msg 
    pc.scanf("%[^\n]s",pc_msg);
    pc.printf("Entered:%s",pc_msg);

    // Read pc_msg and extract all data
    sscanf(pc_msg,"%d %d %d %d %x %x %x %x %x %x %x %x", &pc_format, &pc_type, &pc_ID, &pc_length, 
    &pcd0, &pcd1, &pcd2, &pcd3, &pcd4, &pcd5, &pcd6, &pcd7);
    
    // Printing extracted data, mostly for testing
    pc.printf("Sent: [ ID: %d ",pc_ID);
    pc.printf("length: %d ",pc_length);
    pc.printf("data: %x %x %x %x %x %x %x %x ",pcd0, pcd1, pcd2, pcd3, pcd4, pcd5, pcd6, pcd7);
    pc.printf("type: %d ",pc_type);
    pc.printf("format: %d ]\n",pc_format);
    
    // Setting the data to CANMessage.data format
    setdata(pcd0, pcd1, pcd2, pcd3, pcd4, pcd5, pcd6, pcd7);
    
    // Transmitting CANMessage
    if(can1.write(CANMessage(pc_ID,candata,(char)pc_length,pc_type,pc_format))) {
        pc.printf("Message compiled and sent.\n");
    }
    pc.printf("Please enter any additional commands in the same manner.\n");
    
}

int main() {
    //----------------Initialization-----------------------
    can2.frequency(500000);             //500kbit/s
    can1.frequency(500000);
    can2.monitor(1); //Works without this, in my case.
    //ticker.attach(&cansend, 0.5); //Send every 1 seconds.
    //-----------------------------------------------------
    
    char test;
    char dump;
    pc.printf("Please enter !<format>_<type>_<ID>_<length>_<d0>_<d1>_<d2>_<d3>_<d4>_<d5>_<d6>_<d7> ('_' = space)\n");
        
    while(1) {
        if (pc.readable()) {            // If there's data available from pc
            pc_activity = !pc_activity; // LED
            test = pc.getc();       
            if (test == '!') {          // See if it's a valid message
                pc_msg_read();          // Valid => read the message and extract the data
                //pc.printf("Left pc_msg_read\n"); // "Left the function" test
            }
            else {                      // Invalid data or leftover characters
                pc.printf("Dumped: ");
                while(pc.readable()) {  // Keep dumping the leftovers
                    dump = pc.getc();
                    pc.printf("%c",dump);
                }
            }
            //pc.printf("Leaving pc.readable()\n"); // Left the !test
        }
        if (can2.read(msg)) {
            canread(); //Read when interupted.
        }
    }
}