#include "mbed.h"
#include "EthernetNetIf.h"
#include "TCPSocket.h"

EthernetNetIf eth;
DigitalOut led1(LED1);


TCPSocket tcp;  //The listening port where requests are queued
TCPSocket* link; //The port where accepted requests can communicate

Host local(IpAddr(130,144,2,83), 12345); //mbed IP
Host client;

TCPSocketErr accErr;

void onLinkSocketEvent(TCPSocketEvent e)
{
   switch(e)
    {
    case TCPSOCKET_CONNECTED:
        printf("TCP Socket Connected\r\n");
        break;
    case TCPSOCKET_WRITEABLE:
      //Can now write some data...
        printf("TCP Socket Writable\r\n");
        break;
    case TCPSOCKET_READABLE:
      //Can now read dome data...
        printf("TCP Socket Readable\r\n");
       // Read in any available data into the buffer
       char buff[128];
       while ( int len = link->recv(buff, 128) ) {
       // And send straight back out again
           link->send(buff, len);
           buff[len]=0; // make terminater
           printf("Received&Wrote:%s\r\n",buff);
       }
       break;
    case TCPSOCKET_CONTIMEOUT:
        printf("TCP Socket Timeout\r\n");
        break;
    case TCPSOCKET_CONRST:
        printf("TCP Socket CONRST\r\n");
        break;
    case TCPSOCKET_CONABRT:
        printf("TCP Socket CONABRT\r\n");
        break;
    case TCPSOCKET_ERROR:
        printf("TCP Socket Error\r\n");
        break;
    case TCPSOCKET_DISCONNECTED:
    //Close socket...
        printf("TCP Socket Disconnected\r\n");        
        link->close();
        break;
    default:
        printf("DEFAULT\r\n"); 
      }
}

void onTCPSocketEvent(TCPSocketEvent e)
{
    switch(e) {
        case TCPSOCKET_CONNECTED:
            printf("Connected\n");
        break;
        
        case TCPSOCKET_ACCEPT: {
            accErr = tcp.accept(&client,&link);
            switch(accErr) {
                case TCPSOCKET_SETUP:   printf("Err:Setup\n");      break;  //TCPSocket not properly configured.
                case TCPSOCKET_TIMEOUT: printf("Err:Timeout\n");    break;  //Connection timed out.
                case TCPSOCKET_IF:      printf("Err:Interface\n");  break;  //Interface has problems, does not exist or is not initialized.
                case TCPSOCKET_MEM:     printf("Err:Memory\n");     break;  //Not enough mem.
                case TCPSOCKET_INUSE:   printf("Err:In use\n");     break;  //Interface / Port is in use.
                case TCPSOCKET_EMPTY:   printf("Err:Empty\n");      break;  //Connections queue is empty.
                case TCPSOCKET_RST:     printf("Err:Reset\n");      break;  //Connection was reset by remote host.
                case TCPSOCKET_OK:      printf("Accepted: ");       break;  //Success. 
            }
            link->setOnEvent(&onLinkSocketEvent);
            IpAddr clientIp = client.getIp();
            printf("Incoming TCP connection from %d.%d.%d.%d\r\n", 
            clientIp[0], clientIp[1], clientIp[2], clientIp[3]);
        }
        break;
        
        case TCPSOCKET_READABLE:
            printf("Readable\n");
        break;
        
        case TCPSOCKET_WRITEABLE:
            printf("Writeable\n");
        break;
        
        case TCPSOCKET_CONTIMEOUT:
            printf("Timeout\n");
        break;
        
        case TCPSOCKET_CONRST:
            printf("Reset\n");
        break;
        case TCPSOCKET_CONABRT:
            printf("Aborted\n");
        break;
        
        case TCPSOCKET_ERROR:
            printf("Error\n");
        break;
        
        case TCPSOCKET_DISCONNECTED:
            printf("Disconnected\n");
            tcp.close();
        break;    
    }
}

int main() {
    //********Basic setup********
    printf("Welcome to wireFUSE\n");
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr)
    {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    //****End of basic setup*****
    
    tcp.setOnEvent(&onTCPSocketEvent); //Generate method to deal with requests
    
    //Bind to local port
    printf("Init bind..\n");
    TCPSocketErr bindErr = tcp.bind(local);
    switch(bindErr) {
    case TCPSOCKET_SETUP:   printf("Err:Setup\n");      break;  //TCPSocket not properly configured.
    case TCPSOCKET_TIMEOUT: printf("Err:Timeout\n");    break;  //Connection timed out.
    case TCPSOCKET_IF:      printf("Err:Interface\n");  break;  //Interface has problems, does not exist or is not initialized.
    case TCPSOCKET_MEM:     printf("Err:Memory\n");     break;  //Not enough mem.
    case TCPSOCKET_INUSE:   printf("Err:In use\n");     break;  //Interface / Port is in use.
    case TCPSOCKET_EMPTY:   printf("Err:Empty\n");      break;  //Connections queue is empty.
    case TCPSOCKET_RST:     printf("Err:Reset\n");      break;  //Connection was reset by remote host.
    case TCPSOCKET_OK:      printf("Bound to port\n");  break;  //Success. 
    }
            
    //Listen to local port
    printf("Init listen..\n");
    TCPSocketErr listenErr = tcp.listen();
    switch(listenErr) {
    case TCPSOCKET_SETUP:   printf("Err:Setup\n");      break;  //TCPSocket not properly configured.
    case TCPSOCKET_TIMEOUT: printf("Err:Timeout\n");    break;  //Connection timed out.
    case TCPSOCKET_IF:      printf("Err:Interface\n");  break;  //Interface has problems, does not exist or is not initialized.
    case TCPSOCKET_MEM:     printf("Err:Memory\n");     break;  //Not enough mem.
    case TCPSOCKET_INUSE:   printf("Err:In use\n");     break;  //Interface / Port is in use.
    case TCPSOCKET_EMPTY:   printf("Err:Empty\n");      break;  //Connections queue is empty.
    case TCPSOCKET_RST:     printf("Err:Reset\n");      break;  //Connection was reset by remote host.
    case TCPSOCKET_OK:      printf("Listening\n");      break;  //Success. 
    }
    Timer tmr;
    tmr.start();
    while(1)
    {
        Net::poll();
        if(tmr.read() > 2)
        {
            tmr.reset();
            led1=!led1; //Show that we are alive
            
            //Wait for a connection request
            printf("waiting for client on port 12345\n");
        }
    }
}