

#include "mbed.h"
#include "CAN.h"

Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10);  // rd, td Transmitter
CAN can2(p30, p29); // rd, td Monitor

int counter = 0;
char data[8];

//***************void send is the data you are sending**************
void send() {

//-------------------------CONFIGURATION-----------------------------
// Send this part if you want to configure your LSS compatible motor!
// Read more about the LSS protocol for more information.
// Don't forget to include an "else {}" part.(scroll down some)

    /*if(counter==0) {
        //--------Global Start nodes
        data[0] = (char)(0x01); // NMT Start RemoteNode
        data[1] = (char)(0x00); // Global
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(0000,data,2))) {
            printf("Startup sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==1) {
        //--------LSS Configure Mode
        data[0] = (char)(0x04); // LSS Set Mode
        data[1] = (char)(0x01); // Mode configure
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,2))) {
            printf("LSS Configure mode sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==2) {
        //--------LSS Set Node_ID
        data[0] = (char)(0x11); // LSS Set Node_ID
        data[1] = (char)(0x03); // to Node_ID: 03
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,2))) {
            printf("LSS Set Node_ID to 0x03 sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==3) {
        //--------LSS Set Baudrate
        data[0] = (char)(0x13); // LSS Set Baudrate
        data[1] = (char)(0x00); // 
        data[2] = (char)(0x02); // Baudrate index (500kb/s)
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,3))) {
            printf("LSS Set Baudrate sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==4) {
        //--------LSS Save Config
        data[0] = (char)(0x17); // LSS Save Config
        data[1] = (char)(0x00); 
        data[2] = (char)(0x00); 
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,3))) {
            printf("LSS Save Config sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==6) {
        //--------LSS Operation Mode
        data[0] = (char)(0x04); // LSS Set Mode
        data[1] = (char)(0x00); // Mode operation
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,2))) {
            printf("LSS Operation mode sent \n");
        }
        led1 = !led1;
        counter ++;
    }*/
//-----------------------END OF CONFIGURATION---------------------


//-----------------------Running your motor-----------------------
// Look up how to make your motor run.
// This example works on a FAULHABER 3242 G024 BX4 CC
// Don't forget to include an "else {}". Scroll down a bit.

    if(counter==0) {
        //--------Start node 3--------
        data[0] = (char)(0x01); // Start Node
        data[1] = (char)(0x03); // ID 03
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(0000,data,2))) {
            printf("Start Node_ID 03 sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==1) {
        //--------FAULHABER Mode
        data[0] = (char)(0xFD); // FAULHABER MODE
        data[1] = (char)(0xFF); 
        data[2] = (char)(0xFF);
        data[3] = (char)(0xFF);
        data[4] = (char)(0xFF);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(771,data,5))) {
            printf("Operation mode: FAULHABER sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==2) {
        //--------Switch ON using FAULHABER
        data[0] = (char)(0x0F); // FAULHABER MODE
        data[1] = (char)(0x00); 
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(771,data,5))) {
            printf("Switch ON sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==3) {
        //--------Speed setting
        data[0] = (char)(0x93); // FAULHABER MODE
        data[1] = (char)(0xF4); 
        data[2] = (char)(0x01);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(771,data,5))) {
            printf("Speed = 500RPM sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else if(counter==4) {
        //--------Datarequest setting
        data[0] = (char)(0x40); // FAULHABER MODE
        data[1] = (char)(0x00); 
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(771,data,5))) {
            printf("Requesttype: position sent \n");
        }
        led1 = !led1;
        counter ++;
    }
//--------------------End run motor--------------------------------


//---------------------Request Position----------------------------
// Run this one to request the position of my motor.
// Check the datasheet of your motor to confirm if this works.
    else {
        //--------Positie opvragen
        data[0] = (char)(0x00);
        data[1] = (char)(0x00);
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(643))) {
            printf("Positie check sent \n");
        }
        led1 = !led1;
        counter = 10;
    }
//--------------------End request position-------------------

    
//---------------------Request Status--------------------------
// Run this one to request the status of my motor.
// Check the datasheet of your motor to confirm if this works.
   /* else {
        //--------Status check
        data[0] = (char)(0x00);
        data[1] = (char)(0x00);
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(387))) {
            printf("Status check sent \n");
        }
        led1 = !led1;
        counter = 10;
    }*/
//------------------End request status------------------
  
    
//---------Example------------------

    /*if(counter==0) {
        //--------8 bytes of data
        data[0] = (char)(0xFF);
        data[1] = (char)(0xFF);
        data[2] = (char)(0xFF);
        data[3] = (char)(0xFF);
        data[4] = (char)(0xFF);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,8))) {
            printf("8bytes test sent \n");
        }
        led1 = !led1;
        counter ++;
    }
    else {
        //--------2 bytes of data
        data[0] = (char)(0x00);
        data[1] = (char)(0xAA);
        data[2] = (char)(0x00);
        data[3] = (char)(0x00);
        data[4] = (char)(0x00);
        data[5] = (char)(0x00);
        data[6] = (char)(0x00);
        data[7] = (char)(0x00);
        if(can1.write(CANMessage(2021,data,2))) {
            printf("2bytes test sent \n");
        }
        led1 = !led1;
        counter = 10;
    }*/  
//-------End of example--------------  
}
//*************************************************************


//**********The main program*********************
int main() {
//----------------Initialization-----------------------
    can2.frequency(500000); //500kbit/s
    can1.frequency(500000);
    //can2.monitor(1); //Works without this, in my case.
    ticker.attach(&send, 1); //Send every second
    CANMessage msg;
//-----------------------------------------------------

//---------------The read out----------------------
    while(1) {
        if(can2.read(msg)) {
            printf("Message read with ID: %d\n", msg.id);
            printf("Data: %x", msg.data[0]);
            printf(" %x", msg.data[1]);
            printf(" %x", msg.data[2]);
            printf(" %x", msg.data[3]);
            printf(" %x", msg.data[4]);
            printf(" %x", msg.data[5]);
            printf(" %x", msg.data[6]);
            printf(" %x\n", msg.data[7]);
            printf("Length: %d", msg.len);
            printf(", Type: %d", msg.type);
            printf(", Format: %d\n\n", msg.format);
            led2 = !led2;  //Blink!
        }
    }
//----------------------------------------------------
}
//*********************************************************