#include "mbed.h"
#include "USBSerial.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#include <string> 

using namespace std;
 
#define MMA8451_I2C_ADDRESS (0x1d<<1)

USBSerial serial;
TSISensor tsi;


int main() {
    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
    

    DigitalOut gpo(PTB8);
    DigitalOut led_r(LED_RED);
    DigitalOut led_g(LED_GREEN);
    DigitalOut led_b(LED_BLUE);
    int x, y, z, sldr = 0;
    
    string str("**");

    
    while (true) {

        while(1)
        {
            x = 1 - acc.getAccX() * 100;
            y = 1 - acc.getAccY() * 100 ;
            z = 1 - acc.getAccZ() * 100 ;
            
            sldr = (  tsi.readPercentage() ) *100;
            
            str =  "**";
            
            if( z > 50 )
               str = "+Z";
            if( z < -50 )
               str = "-Z";  
               
            if( x > 50 )
               str = "+X";
            if( x < -50 )
               str = "-X"; 
                
            if( y > 50 )
               str = "+Y";
            if( y < -50 )
               str = "-Y";  
            
            serial.printf("X=%4d, Y=%4d, Z=%4d, osa=%s, slider=%3d%%\r\n", x, z, y, str, sldr);
            wait(0.3);           
           
        }
            

            
        led_r = 0; // Off
        wait(1);
        
        led_r = 1; // Off
        led_b = 1; // Off
        led_g = 1; // Off
        wait(1);
        
        led_g = 0; // Off
        wait(1);
        
        led_r = 1; // Off
        led_b = 1; // Off
        led_g = 1; // Off
        wait(1);
       
        led_b = 0; // Off
        wait(1);
        
        led_r = 1; // Off
        led_b = 1; // Off
        led_g = 1; // Off
        wait(1);
        
      
  
    }
}