#include "mbed.h"
#include "TextLCD.h"
BusOut leds(D14,D15);//creates a global busout that identifies the pins associated with the leds. 
bool keycode();//Function prototype for the function that checks if the correct keycode was entered(returns boolean)
float readtempurature(AnalogIn *temp);//function prototype fot the readtempurature function(this function was done by ben)
char scan4by3keypad(BusIn* col, BusOut* row, const char k[4][3]); //function prototype for the scan4by3keypad function(returns a char) 
TextLCD lcd(D6, D5, D4, D3, D2, A0); // creates a global object of the TextLCD class called lcd with the pins D6,D5,D4,D3,D2,A0 assigned. These pins correspond to the pins rs, e, d4-d7 on the lcd  
char usercode[4] = {' ',' ',' ',' '};//creates a global char array that is used to store the entered code. This array is initialized to nothing 


char const MGPIOB=0x13;
char const MOLATB=0x15;     //modified
char const MIODIRB=0x01;
char const MGPPUB=0x0D;
char const MGPIOA=0x12;
char const MOLATA=0x14;
char const MIODIRA=0x00;
char const MGPPUA=0x0C;

char const initWriteByte = 0b01000000;
char const initReadByte = 0b01000001;



/************************************************************************************
Main function:
Purpose: The purpose of the main function is to determine the usercode entered from the keypad. If the code is correct the function will light the green
led, print access granted, and then the temperature to the LCD display. if the code entered is incorrect, the function will prompt the user to try again and light the red LED.

Pins declared:
temp(A1,AnalogIn): This pin is used to bring the value of the thermistor onto the nucleo board since it is an analog value the pin is declared as AnalogIn.
rowpins(D13,D12,D11,D10, BusOut): These pins are declared as a bus out and are connected to the row pins of the keypad. The pins will be used to turn the bus pins high.
columnpins(D9,D8,D7, BusIn): These pins are declared as a bus in and are connected to the column pins of the keypad. The pins are used to read the state of the column pins to determine if a key has been pressed.

Variables:
button(const char): a 4 by 3 array that is used to store the char equivalent to the keys on the keypad.
access(bool): a boolean variable that is true if the code entered is correct, and is false if the code entered is incorrect.

Functions: 
lcd.cls(): a function of the lcd class that will clear the lcd display
lcd.printf(""):a function of the lcd class that will print to the lcd display
lcd.locate(c,r): a function of the lcd class that will move the cursor to the column(c) and row(r) on the lcd that is specified. 
scan4by3keypad(&columnpins, &rowpins, button):a function created previously that accepts the addresses of the row and column pins as well as the value of the button array. This function returns the char representing
the button pressed.
wait(x): waits x amount of seconds then continues with the function.
if(condition){}:the if statement will run the code contained in the curly brackets if the condition is met
else{}: the else statment is attached to an if statement and runs the code contained in the curly brackets if the condition of the if statement is not met
leds[x].write(y):writes y(either a 1 or 0) to the pin at the position x in the leds busout. 
while(condition){}:continues to loop through the code contained in the curly brackets while the condition is met. The loop will be broken if the condition is not met. 
for(;;){}: runs the code contained in the brackets forever and ever.
readtempurature(&temp): A function created by Ben that returns a value of type float representing the temperature. This function accepts the address of the temp pins. 
*************************************************************************************/
int main() {
    SPI spi(PC_12,PC_11,PC_10); //mosi, miso, sclk
    DigitalOut cs(A5);
    AnalogIn temp (A1);//indentifies the pin A1 as an analogin pin named temp
    BusOut rowpins(D13,D12,D11,D10);//busout for my row pins
    BusIn columnpins(D9,D8,D7);//busin for my colummn pins
    columnpins.mode(PullDown);//enables the internal pulldown for the column pins
    const char button[4][3]= {{'1','2','3'},
                             {'4','5','6'},
                             {'7','8','9'},
                             {'4','0','#'}};//array which helps determine which button was 
    bool access = false;//boolean variable that will change depending on whether the keycode is correct or incorrect.
    
    spi.format(8,0);            //set spi to transfer 8 bits with SPI MODE 0 (0,0)
    spi.frequency(1000000);     //set spi clock to 1MHz
    
    while(access == false)//loops through this code while the access is false (keycode entered is wrong)
    {
        lcd.cls();//clears the LCD display
        lcd.printf("Enter Code:\n");//prints "enter code" to the LCD display.
        lcd.locate(11,0);//moves the cursor to the 11th column of the 0th row on the lcd display
        usercode[0] = scan4by3keypad(&columnpins, &rowpins, button);//sets the first value of usercode to the char returned by the scan4by3keypad function.
        lcd.printf("*");//prints a * to the lcd at the 11th column of the 0th row ro show that a value has been entered into the usercode
        wait(0.5);//waits half a second
        usercode[1] = scan4by3keypad(&columnpins, &rowpins, button);//sets the second value of usercode to the char returned by the scan4by3keypad function.
        lcd.locate(12,0);//moves the cursor to the 12th column of the 0th row on the lcd display
        lcd.printf("*");//prints a * to the lcd at the 12th column of the 0th row ro show that a value has been entered into the usercode
        wait(0.5);//waits half a second
        usercode[2] = scan4by3keypad(&columnpins, &rowpins, button);//sets the third value of usercode to the char returned by the scan4by3keypad function.
        lcd.locate(13,0);//moves the cursor to the 13th column of the 0th row on the lcd display
        lcd.printf("*");//prints a * to the lcd at the 13th column of the 0th row ro show that a value has been entered into the usercode
        wait(0.5);//waits half a second.
        usercode[3] = scan4by3keypad(&columnpins, &rowpins, button);//sets the fourth value of usercode to the char returned by the scan4by3keypad function.
        lcd.locate(14,0);//moves the cursor to the 14th column of the 0th row on the lcd display
        lcd.printf("*");//prints a * to the lcd at the 14th column of the 0th row ro show that a value has been entered into the usercode
        wait(1);//waits one second
        if(keycode() == true)//if the keycode is correct this code will run (breaks the loop)
        {
            lcd.cls();//clears the lcd completely
            lcd.locate(0,0);//moves the cursor to the 0th column of the 0th row of the LCD
            lcd.printf("Access granted!\n");//prints "Access granted" to the LCD
            leds[0].write(1);//writes 1 to the 0th value of the leds busout. (green LED)
            wait(1);//waits one second
            leds[0].write(0);//writes 0 to the 0th value of the leds busout. (green LED)
            access = true;//sets access to true which breaks the while loop. 
        }
        else//if the keycode is not correct this code will run (does not break the loop)
        {
            lcd.cls();//clears the lcd completely
            lcd.locate(0,0);//moves the cursor to the 0th column of the 0th row of the LCD
            lcd.printf("Access Denied!");//prints "Access Denied!" to the LCD display
            leds[1].write(1);//writes 1 to the 1st value of the leds busout(red led)
            wait(1);//waits one second
            leds[1].write(0);//writes 0 to the 1st value of the leds busout(red led)

        }
    }
    for(;;)//infinite loop
    {
        float tempurature;
        float y;//float value that stores the duty-cyle calculated on line 15
        int bite;
        tempurature=readtempurature(&temp); //calls the temperature function and stores its return value
        y = (((0.25*tempurature) + 3)/100); //formula that converts the temperature measured by the thermistor into an equivalent duty-cycle, in order for the servo to display an accurate 1:1 scale, change the constant from 0.3 to 0.05
        //servo.period(0.02);  // sets the period of the servo PWM to 20 ms as specifed in lesson 7
        //servo.write(y); //writes the calculated duty-cycle to the servo 
        bite=((28.333333333333*(y*100))-85);
        //printf("The tempurature is: %f\n",tempurature);//prints the temperature in celcius to the serial terminal
        //wait(0.5); //waits for half a second before running the next iteration
        cs = 0;
        spi.write(bite); //writes the calculated duty-cycle to the servo
        printf("Bite = %.2f", bite);
        wait(0.5);
        cs = 1;
        //printf("The tempurature is: %f\n",temperature);//prints the temperature in celcius to the serial terminal
        //wait(0.5); //waits for half a second before running the next iteration
        lcd.locate(0,1);//moves the cursor to the 0th column of the first row on the LCD
        lcd.printf("Temp: %.2f",tempurature);//prints the value returns by the readtempurature function.(.2f will cutoff the value after the second decimal place.
        wait(1.5);//waits 1.5 seconds as to no make the display look all glitchy.
    } 
 }  
/********************************************************************************
keycode function:
purpose: The purpose of this function is compare the value of the global array usercode to the correct codes specified by the PM. this function returns true if the code is one of the correct codes and will 
return false if the code is not correct. 

Passed variables: 
None

Returned variables: 
status(bool)

Pins Declared: 
None

variables:
status(bool): a boolean variable that will be set true if the keycode is correct, the variable will be set to false if the keycode is incorrect.
usercode[]:A global array containing the user entered code. 

functions:
if(condition){}:the if statement will run the code contained in the curly brackets if the condition is met
return:returns the variable or value to the function that this function was called from.
********************************************************************************/
bool keycode()
 {
    bool status = false;//creates a boolean variable called status that is initialized to false
    if(usercode[0] == '1' && usercode[1] == '2' && usercode[2] == '3' && usercode[3] == '4'||//if usercode array is 1234 or 4321 or 0000
       usercode[0] == '4' && usercode[1] == '3' && usercode[2] == '2' && usercode[3] == '1'||
       usercode[0] == '0' && usercode[1] == '0' && usercode[2] == '0' && usercode[3] == '0')
    {
        status = true;//sets status to true
    }
    return status;//returns the value of status.
}
/*************************************************
scan4by3keypad function:
function: This function will loop through rows turning each row high and then reads the columns and if that column is high
it can determine which button was pressed. This uses blocking polling. 

variables:
row (BusOut): creates the busout for my row pins
col (BusOut): creates a busout for my column pins
k (const char): an array containing the values of the buttons to be used when printing what button was pressed
buttonpressed (char): a char buffer which stores the char value at the point in the k array depending what button is pressed.
j (int): loop condition associated with my row pins
isbuttonpressed (int): This int is the while loop condiition. 

functions:
pin->write(0b0001<<j): will write the byte to the pins specified and will shift depending on what value j is
pin->read(): reads from the associated pin(s)
printf(): prints to the terminal
switch col->read(): will look at the case associated with what returns from the column read.
while(condition): will keep looping what is inside of the loop until the condition is not met. This is used for my blocking polling. 
****************************************************/
char scan4by3keypad(BusIn* col, BusOut* row, const char k[4][3])
{       char buttonpressed;
        int isbuttonpressed=0;
    while(isbuttonpressed==0)
    {     
        for(int j=0;j<4;j++)//loops j which will be used to turn the rows on
        {
            row->write(0b0001<<j);//writes a 1 to the jth pin
            switch (col->read())
            {
                case 0b001://if the first column is high
                buttonpressed = k[j][0];//equals the array at the jth and zero position.
                isbuttonpressed=1;//breaks the while loop
                break;
                   case 0b010://if the second column is high
                buttonpressed = k[j][1];//equals the array at the jth and one position.
                isbuttonpressed=1;//breaks the while loop
                break;
                   case 0b100://if the third column is high
                buttonpressed = k[j][2];//equals the array at the jth and second position
                isbuttonpressed=1;//breaks the while loop
                break;
            }   
            row->write(0b0001<<j);//resets the jth pin low so there is no confusion as to what button is pressed
        }
     } 
    return buttonpressed;//returns the char value stored in the array  
}
/**********************************************************************************************************
    Description: The purpose of this function is to calculate the temperature being read by the thermistor
        In order for this code to work, you must connect a 10k resistor in series with the thermistor. The wire from A1 on the nucleo f411RE must be connected after the resistor.  The voltage being used in this circuit is 3.3V.
        Below you will find a rough drawing of what the circuit should look like 
        
                 3.3V---------Resistor---wire from A1-------Thermistor-------GND
    
    Parameters:
           
            temp->Defines the analog input pin used to measure the voltage of the thermistor
                          
            
    Returns:
            celcius: Returns the tempurature measured by the thermistor in degrees celsius as a float value
**********************************************************************************************************/
float readtempurature(AnalogIn *temp)
{
    float tempVal; //variable that stores the voltage reading of the thermistor as a value between 1 and zero 
    tempVal=temp->read(); //reads the voltage of the thermistor on analog pin 1 of the nucleo f411RE
    float vrt; //variable that stores the actual value of the voltage of the thermistor
    vrt=(tempVal*3.3);//this formula determines the actual voltage of the thermistor
    float top;//variable that defines the numerator of the formula to determine the resistance of the thermistor
    top=(vrt*10000);//numerator of the formula used to determine the thermisistor resistance
    float bottom; //variable that defines the denominator of the formula to determine the resistance of the thermistor
    bottom=(3.3-vrt); //denominator of the formula to determine the thermisistor resistance
    float rt=(top/bottom);//this is the formula to determine the thermisitor resistance
    float A=(3.354016e-3);//Constant A1 in the formula used to calculate the temperature given the resistance of the thermisitor
    float B=(2.569650e-4);//Constant B1 in the formula used to calculate the temperature given the resistance of the thermisitor
    float C=(2.620131e-6);//Constant C1 in the formula used to calculate the temperature given the resistance of the thermisitor
    float D=(6.383091e-8);//Constant D1 in the formula used to calculate the temperature given the resistance of the thermisitor
    float ln1=(log(rt/10000)); //First ln operation in the formula used to calculate the temperature given the resistance of the thermisitor
    float ln2=log(pow((rt/10000),2));//Second ln operation in the formula used to calculate the temperature given the resistance of the thermisitor
    float ln3=log(pow((rt/10000),3));//Second ln operation in the formula used to calculate the temperature given the resistance of the thermisitor
    float denominator=(A+(B*ln1)+(C*ln2)+(D*ln3)); //complete denominator of the formula used to calculate the temperature given the resistance of the thermisitor
    float  celcius=((1/denominator)-273.15);//completed formula to calculate the tempurature given the resistance of the thermisitor
    
    return celcius; //returns the value of the tempurature in degrees celsius
}
