/**
@file ParameterController.h

*/

#ifndef PARAMETERCONTROLLER_H
#define PARAMETERCONTROLLER_H

#include "mbed.h"
#include "Outputs.h"

/**
@brief Manages the display of parameter data on the LCD. 
@brief paramters used in the project like temperature, pressure and baterry voltage
@author Augustine Kizito K
@date April 2015
*/

class ParameterController
{
private:
    char value[32]; // value of the parameter
    char parameter[32]; // name of the parameter
    char unit[32]; // unit of the parameter
    char sentiment[32]; // sentiment of the parameter

protected:
    /**
    Creates a parameter controller intstance
    
    @param p - string name of parameter
    @param u - string units of parameter
    
    */
    ParameterController(char p[], char u[] ); 
    
    /**
    Set the sentiment of the parameter
    
    @param s - string sentiment of parameter 
    
    */
    void setSentiment(char s[]);
    
    /**
    Set the value of the parameter
    
    @param v - float v value of parameter
     
    */
    void setValue( float v); 
    
    /**
    Set the units of the parameter
    
    @param u - string unit of parameter
    
    */
    void setUnit(char u[]);
    
    /**
    Populate the LCD screen with the appropriate parameter data
    
    */
    void showInfo(); 
    
    /**
    Update the LCD screen with new data
    
    */
    void updateInfo();

};













ParameterController::ParameterController( char p[], char u[]) // constructor
{

    strcpy(parameter,p);
    strcpy(unit,u);

}

void ParameterController::setValue( float v)   // set the current value of the parameter
{

    sprintf(value,"%0.2f",v); // converting float to string
}

void ParameterController::setSentiment( char s[])  // set the current current sentiment of the value
{
    strcpy(sentiment,s);
}

void ParameterController::showInfo()  // populate the screen with Controller data
{
    lcd.printString(parameter,15,1); //  print parameter
    lcd.printString(value,0,2);    // print value
    lcd.printString(unit,0,3);    // print unit
    lcd.printString("Sentiment:",0,4);
    lcd.printString(sentiment,0,5); // print sentiment

    lcd.refresh(); // refresh the lcd screen

}

void ParameterController::updateInfo()  // update the screen with new info
{
    lcd.printString(value,0,2);    // print value
    lcd.printString(unit,0,3);    // print unit
    lcd.printString(sentiment,0,5); // print sentiment

    lcd.refresh(); // refresh the lcd screen

}

void ParameterController::setUnit( char u[])
{
    strcpy(unit,u);

}

#endif