/**
@file Outputs.h
@brief Contains all the outputs required for the weather station application\n
@brief the outputs are N5110 LCD screen, piezo buzzer, red LED and blue LED 
@author Augustine K Kizito
@date April 2015
*/

#ifndef OUTPUTS_H
#define OUTPUTS_H

#include "N5110.h"
#include "beep.h"
#include "PowerControl/PowerControl.h"

N5110 lcd(p7,p8,p9,p10,p11,p13,p26); // pwm for led backlight
Beep buzzer(p21); // pwm for buzzer

DigitalOut logLed(p24); //led that turns on when logging
DigitalOut batStatLed(p23); // led that turns on when battery voltage is low

Ticker batStatTimer;
bool batStatLedState = false; // tracks if the batStatLed is in use

void turnOnBatStatLed() // turns on the battery status led
{
    if(!batStatLedState) { //  battery status led is not already on
        // turn it on
        batStatLed = 1;
        // call this function every 2 seconds
        batStatTimer.attach(&turnOnBatStatLed,2);
        // battery status led is now in use
        batStatLedState = true;
    } else { // battery status led is already on

        // toggle the battery status led
        batStatLed = !batStatLed;
    }

}

void turnOffBatStatLed() // turns off the battery status led
{
    // battery status led is still on
    if (batStatLedState) {
        // disable the interrupt that toggles the led
        batStatTimer.detach();
        // the battery status led is off
        batStatLedState = false;
        // turn off the battery status led
        batStatLed = 0;

    }

}

Ticker logLedTimer;
bool logLedState = false; // tracks if the log Led is in use

void turnOnLogLed() // turns on the log led
{
    if(!logLedState) { //  log led is not already on
        // turn it on
        logLed = 1;
        // call this function every 2 seconds
        logLedTimer.attach(&turnOnLogLed,2);
        // log led is now in use
        logLedState = true;
    } else { // log led is already on

        // toggle the log led
        logLed = !logLed;
    }

}

void turnOffLogLed() // turns off the log led
{
    // log led is still on
    if (logLedState) {
        // disable the interrupt that toggles the led
        logLedTimer.detach();
        // the log led is off
        logLedState = false;
        // turn off the log led
        logLed = 0;

    }

}

bool soundFx = true; // variable that tracks the sound effects
int currentBrightness; // variable that tracks the LCD brightness

void playSound()
{
    if (soundFx) { // the sound effects are activated
 
        // if brightenss is at 50 or 20 % , reduce buzzer frequency.
        // this is implemented because the above modes seem to affect the 
        // PWM signal to the LCD brightness. Reducing the buzzer frequency
        // somewhat alleviates this problem
        
        if (currentBrightness == 50 || currentBrightness == 25 ) {
              buzzer.beep(80,0.05); // sound 80kHz tone

        } else { // sound the normal 2kHz Tone
              buzzer.beep(2000.0,0.1);
        }


    
    }


}


#endif