/**
@file MainMenuScreen.h

*/
#ifndef MAINMENUSCREEN_H
#define MAINMENUSCREEN_H

#include "ListController.h"
#include "Inputs.h"

/**
@brief Displays the main menu on the LCD screen\n 
@brief It is a list with four selectable options :\n
@brief temperature, pressue , log and settings
@author Augustine Kizito K
@date April 2015
*/



class MainMenuScreen : public ListController
{
private:
    bool changeScreen; // tracks if the user pressed a button that changes the screen
    int nextScreen; // tracks whether the user wants to go to
    //the previous screen or next screen

    void onScrollUp(); // user pressed the scroll up button
    void onScrollDown(); // user pressed the scroll down button
    void onEnter(); // user pressed the enter button

public:
    /**
    Creates an instance of the main menu screen
    
    */
    MainMenuScreen()
        :ListController( "MainMenu", // Title
                         "Temperature", // Option 1
                         "Pressure", // Option 2
                         "Log", // Option 3
                         "Settings", // Option 4
                         4) // Number of Options
    {};
    /*
    Manages the execution of the main menu screen
    
    @returns
    0  - User selected option 1\n
    1  - User selected option 2\n
    2  - User selected option 3\n
    3  - User selected option 4\n
    
    */
    int start(); 


};
int MainMenuScreen::start()
{


    enterButton.mode(PullDown); // activate pull down resistor
    upButton.mode(PullDown); // activate pull down resistor
    downButton.mode(PullDown); // acivate pull down resistor

    upButton.rise(this,&MainMenuScreen::onScrollUp); // call onScrollUp when the up button is pressed
    downButton.rise(this,&MainMenuScreen::onScrollDown); // call onScrollDown when the down button is pressed
    enterButton.rise(this,&MainMenuScreen::onEnter); // call onEnter when the enter button is pressed

    // Launch the List Controller
    ListController::showInfo();
    changeScreen = false;

    debounce.start(); // start the debouncing timer

    while(!changeScreen) {

        // mbed goes to sleep to save power
        Sleep();
    }

    // detach all interrupts
    upButton.rise(NULL);
    downButton.rise(NULL);
    enterButton.rise(NULL);
    backButton.rise(NULL);

    return nextScreen;
}

void MainMenuScreen::onScrollUp()
{
    if (debounceSuccess()) { // debouncing successful

        ListController::scrollUp(); // scroll up
        debounce.reset(); // reset the debounce timer
    }
}

void MainMenuScreen::onScrollDown()
{
    if (debounceSuccess()) { // debouncing successful

        ListController::scrollDown(); // scroll down
        debounce.reset(); // reset the debounce timer
    }
}

void MainMenuScreen::onEnter()
{
    if (debounceSuccess()){ // debouncing successful
    // sound the buzzer
    playSound();
    nextScreen = ListController::getCurrentOption(); //  get the option that user selected
    changeScreen = true; // user wants to go to a different screen
    // reset the debounce timer
    debounce.reset();
    }
}

#endif