/**
@file LogOptionScreen.h
*/
#ifndef LOGOPTIONSCREEN_H
#define LOGOPTIONSCREEN_H

#include "ListController.h"
#include "Inputs.h"

/**
@brief Allos the user to select which parameter they would\n
@brief like to log or view a previous log i.e either temperature or pressure\n
@brief it consists of a list controller with two options
@author Augustine K Kizito
@date April 2015
*/


class LogOptionScreen : public ListController // inherit the list Controller properties
{
private:
    bool changeScreen; // tracks if the user pressed a button that changes the screen
    int nextScreen; // tracks whether the user wants to go to
    //the previous screen or next screen

    void onScrollUp(); // user pressed the scroll up button
    void onScrollDown(); // user pressed the scroll down button
    void onEnter(); // user pressed the enter button
    void onBack(); // user pressed the back button

public:
    /**
    Creates an instance of the log options screen
    
    */
    LogOptionScreen()
        :ListController( "Parameter", // Title
                         "Temperature", // Option 1
                         "Pressure", // Option 2
                         "", // Option 3
                         "", // Option 4
                         2) // Number of Options
    {};
    /**
    Manages the execution of the Log Options Screen
    
    @returns
    
    -1 - Navigate to previous screen\n
    0  - User selected option 1\n
    1  - User selected option 2
    
    */
    int start();


};






int LogOptionScreen::start()
{

    // Activate PullDown Resistors
    enterButton.mode(PullDown);
    upButton.mode(PullDown);
    downButton.mode(PullDown);
    backButton.mode(PullDown);

    upButton.rise(this,&LogOptionScreen::onScrollUp); // call onScrollUp when the up button is pressed
    downButton.rise(this,&LogOptionScreen::onScrollDown); // call onScrollDown when the down button is pressed
    enterButton.rise(this,&LogOptionScreen::onEnter); // call onEnter when the enter button is pressed
    backButton.rise(this,&LogOptionScreen::onBack); // call onBack when the back button is pressed
    
    // Launch the List Controller
    ListController::showInfo();
    changeScreen = false;

    debounce.start(); // start the debounce timer

    while(!changeScreen) {

        // mbed goes to sleep to save power
        Sleep();
    }

    // detach all interrupts
    upButton.rise(NULL);
    downButton.rise(NULL);
    enterButton.rise(NULL);
    backButton.rise(NULL);

    return nextScreen;
}

void LogOptionScreen::onScrollUp()
{
    if (debounceSuccess()) {  // check if debouncing succeeded

        ListController::scrollUp(); // scroll up
        debounce.reset(); // reset the debounce timer
    }
}

void LogOptionScreen::onScrollDown()
{
    if (debounceSuccess()) { // check if debouncing succeeded

        ListController::scrollDown(); // scroll down
        debounce.reset(); // reset the debounce timer
    }
}

void LogOptionScreen::onEnter()
{
    if (debounceSuccess()) { // check if debouncing succeeded
        // Sound the buzzer
        playSound();
        nextScreen = ListController::getCurrentOption(); //  get the option that user selected
        changeScreen = true; // user wants to go to a different screen
        debounce.reset(); // reset the debounce timer
    }
}

void LogOptionScreen::onBack()
{
    if(debounceSuccess()) { // debouncing succeeded
      // sound the buzzer
      playSound();
      nextScreen = -1; // go to previous screen
      changeScreen = true; // user wants to go to a different screen
      debounce.reset();
    }

}

#endif