/**
@file Inputs.h
@brief All the necessary inputs for the weather application are stored in this file\n
@brief Inputs in this case are buttons.\n
@brief A timer was also implemented that would compensate for multiple interrupts when buttons are pressed\n
@author Augustine K Kizito\n
@date April 2015
*/
#ifndef INPUTS_H
#define INPUTS_H

#include "ConfigFile.h"


//Button Objects
InterruptIn upButton(p17); // up Button
InterruptIn downButton(p18); // down Button
InterruptIn enterButton(p16); // enter Button
InterruptIn backButton(p15); // back Button

LocalFileSystem local("local"); // create local file system object
ConfigFile cfg; // create ConfigFile object

// timer that is used to observe and prevent multiple interrupts
Timer debounce;

void debounceReset() // resets the debounce timer
{
    debounce.reset(); // reset the timer

}

// ticker that resets the debounce every 20 minutes to prevent
// program from freezing
Ticker rdb;
void debounceInit()
{
    rdb.attach(&debounceReset,1200.0); // call debounce reset after 20 minutes
}
//void debounceReset(); // resets the debounce timer
//rdb.attach(&debounceReset,1200.0); // call debounce reset after 20 minutes

bool debounceSuccess()// checks if debouncing was successful
{

    if (debounce.read_ms() > 200) { // check if the debounce timer is more than 200ms
        return true;
    }

    else {
        return false;
    }
}




#endif