/**
@file TemperatureViewLogScreen.h

*/
#ifndef TEMPVIEWLOGSCREEN_H
#define TEMPVIEWLOGSCREEN_H

#include "DataController.h"
#include "Inputs.h"

/**
@brief Displays the Temperature options
@brief It is a list with two selectable options :\n
@brief view temp and temp plot\n
@brief view temp shows the current temperature along with the sentiment\n
@brief temp plot plots the temperature against time on the LCD screen at various intervals\n
@author Augustine Kizito K
@date April 2015
*/

class TempViewLogScreen : public DataController
{
private:

    void onEnter(); // user pressed the enter button
    void onBack(); // user pressed the back button

public:
    /**
    Creates a Temperature View Log Screen instance
    
    */
    TempViewLogScreen()
        :DataController( "/local/temp.cfg", // File location
                         1) // parameter, 1 for temperatue, 0 for pressure
    {};
    /**
    Manages the execution of the Temperature View Log Screen
    
    @returns 
    
    -1 - Navigate to previous screen
    
    */
    int start(); // Manages the execution of the Temperature Screen


};






int TempViewLogScreen::start()
{
    enterButton.mode(PullDown);
    backButton.mode(PullDown);
    
    enterButton.rise(this,&TempViewLogScreen::onEnter); // call onEnter when the enter button is pressed
    backButton.rise(this,&TempViewLogScreen::onBack); // call onBack when the back button is pressed
    
    debounce.start();
    
    DataController::begin();

    enterButton.rise(NULL);
    backButton.rise(NULL);
    return -1;
}

void TempViewLogScreen::onEnter()
{
   if (debounceSuccess()) { // check if debouncing succeeded
        // sound the buzzer
        playSound();
        DataController::nextPage(); 
        debounce.reset(); // reset the debounce timer
    }  

}

void TempViewLogScreen::onBack()
{
    if (debounceSuccess()) { // check if debouncing succeeded
        //sound the buzzer
        playSound();
        DataController::previousPage();
        debounce.reset(); // reset the debounce timer
    }
}

#endif