/**
@file SettingController.h

*/

#ifndef SETTINGCONTROLLER_H
#define SETTINGCONTROLLER_H

#include "Outputs.h"

/**
@brief Has the same features as the List Controller.\n
@brief Displays the current state of a given setting on the screen\n
@author Augustine Kizito K\n
@date April 2015
*/

class SettingController
{
private:
    int currentSetting; // the previously set setting
    char title[32];  // title of the setting
    char option1[32]; // the 1st option
    char option2[32]; // the 2nd option
    char option3[32]; // the 3rd option
    char option4[32]; // the 4th option
    int currentOption; // the current cell position
    int numberOfOptions; // the number of available of options
    void setSetting(int option); // make this option a new setting
    void invertPixels(int option); // highlights pixels in a bank
    void removeSetting(int option); //  remove this option as a setting


protected:
    /**
    Creates a Setting Controller instance
    
    @param t - string title of list
    @param op1 - option 1 on the list
    @param op2 - option 2 on the list
    @param op3 - option 3 on the list
    @param op4 - option 4 on the list
    @param nOO 0 - available number of options
    
    */
    SettingController( char t[], char opt1[],char opt2[], char opt3[], char opt4[],int nOO); 
    
    /**
    Populates the LCD screen with the a list of browse-able and selectable options
    
    */
    void showInfo();
    
    /**
    Scrolls to the next option
    
    */
    void scrollDown();
    
    /**
    Scrolls to the previous option
    
    */
    
    void scrollUp(); 
    
    /**
    Gets the current/highlighted option and returns is to the calling function
    
    @returns the currentt option 0 - 3
    */
    
    int getCurrentOption(); 
    
    /**
    Updates the LCD screen with new data
    
    */
    void updateData();
    
    /**
    Makes an option the current setting
    
    @param cS - integer location of the setting to be made the current setting
    
    */
    void setCurrentSetting(int cS);
    
    /**
    Gets the location of the current setting and returns it
    
    @returns - interger location of current setting 0 - 3
    
    */
    
    int getCurrentSetting(); 
    
    /**
    Changes the current setting to the new setting
    
    */
    void changeSetting(); 


};





















SettingController::SettingController( char t[], char op1[], char op2[], char op3[], char op4[], int nOO )
{
    // initilaisations
    strcpy(title,t);
    strcpy(option1,op1);
    strcpy(option2,op2);
    strcpy(option3,op3);
    strcpy(option4,op4);
    numberOfOptions = nOO;
    currentOption = 0;

}

void SettingController::showInfo()
{
    lcd.printString(title,0,1); //  print title
    lcd.printString(option1,0,2);  // print option1
    lcd.printString(option2,0,3);  // print option2
    lcd.printString(option3,0,4); // print option3
    lcd.printString(option4,0,5); // print option4


    setSetting(currentSetting);
    invertPixels(currentOption); // highlight the current option


}

void SettingController::scrollUp()
{
    playSound(); // sound the buzzer
    invertPixels(currentOption); // UN invert/highlight current option
    currentOption--;  // current position is less by 1

    if (currentOption < 0) { // prevents from inverting a non existent option

        currentOption = 0;
        invertPixels(currentOption); // invert all pixels in current bank

    } else {
        invertPixels(currentOption); // invert all pixels in current bank
    }
}

void SettingController::scrollDown()
{
    playSound(); // sound the buzzer
    invertPixels(currentOption); // UN-invert/highlight the current option
    currentOption++; // current option is more by 1

    if (currentOption > numberOfOptions-1) { // prevents from inverting a non existant option

        currentOption = numberOfOptions-1;
        invertPixels(currentOption); // invert all pixels in current option
    } else {
        invertPixels(currentOption); // invert all pixels in current option
    }
}

int SettingController::getCurrentOption()
{

    return currentOption;
}

int SettingController::getCurrentSetting()
{

    return currentSetting;
}
void SettingController::setCurrentSetting( int cs)
{
    currentSetting = cs;
}

void SettingController::invertPixels(int option)
{
    int onset; // x coordinate where inversion starts

    // first bank consists of status bar showing time and battery icon
    // second bank consists of the title

    if (option == 0) { // invert third bank
        onset = 15;
    } else if ( option == 1) { // invert fourth bank
        onset = 23;
    } else if ( option == 2) { // invert fifth bank
        onset = 31;
    } else {
        onset = 39;  // invert sixth bank
    }

    int termination = onset + 9; // bank's length height is 9 pixels

    for ( int m = onset; m < termination; m++) {

        for ( int n = 0; n < 84; n++) {

            if((lcd.getPixel(n,m)) == 0) { // if the pixel is clear
                lcd.setPixel(n,m);  // set the pixel
            } else {
                lcd.clearPixel(n,m); // else clear the pixel
            }

        }
    }

    lcd.refresh(); // refresh the lcd screen

}

void SettingController::changeSetting()
{
    //saveSetting();
    //first un-invert the current option
    invertPixels(currentOption);
    //then remove the setting from option it was
    removeSetting(currentSetting);
    // make the new option as the new setting
    setSetting(currentOption);
    //update the current setting
    currentSetting = currentOption;
    // ivert the current option
    invertPixels(currentOption);
}

void SettingController::removeSetting(int option)
{
    // remove the setting marker from the option by removing the letter o

    if ( option == 0 ) {
        lcd.printString(" ",78,2); //option1
    } else if ( option == 1 ) {
        lcd.printString(" ",78,3); //option2
    } else if ( option == 2 ) {
        lcd.printString(" ",78,4); //option3
    } else {
        lcd.printString(" ",78,5); //option4
    }

}

void SettingController::setSetting(int option)
{
    // make the current position as the new setting by adding letter 0
    // at the end of the option

    if ( option == 0 ) {
        lcd.printString("o",78,2); //option1
    } else if ( option == 1 ) {
        lcd.printString("o",78,3); //option2
    } else if ( option == 2 ) {
        lcd.printString("o",78,4); //option3
    } else {
        lcd.printString("o",78,5); //option4
    }
    lcd.refresh();

}

#endif