/**
@file sensors.h
@brief this file contians functions that allow the user to access the sensors used in for the project\n
@brief the sensors are barameter, thermometer and a simple voltage divider that measures voltage\n
@author Augustine K Kizito
@date April 2015
*/
#ifndef SENSORS_H
#define SENSORS_H

#include "BMP180.h"

BMP180 bmp180(p28,p27);   // SDA, SCL
AnalogIn ain(p20); // connected to PP3 battery, used to measure voltage

/**
Reads the current temperature from the BMP180 sensor and returns the value

@returns float temperature in degrees celsius

*/
float getTemperature();
/**
Reads the current pressure from the BMP180 sensor and returns the value

@returns float pressure in mbars

*/
float getPressure();
/**
Reads the voltage reading across the potential divider connecte to the PP3 Battery

@returns float battery voltage in Volts 
*/
float getVoltage();




float getTemperature()
{
    float temperature; // stores temperature in deg Cel

    if (bmp180.ReadData(&temperature,NULL)) {
        // tempeature value is returned successfully

    } else {
        // sensor failed
        temperature = -100;
    }

    return temperature;
}

float getPressure()
{
    float pressure; // stores pressure in hPa

    if (bmp180.ReadData(NULL, &pressure)) {
        // pressure value is returned successfully

    } else {
        // sensor failed
        pressure = -10;
    }

    return pressure;

}

float getVoltage()
{
    // calculate voltage
    float voltage = ain*9.9+1.8;
    
    return voltage;

}

#endif