/**
@file PressureViewLogScreen.h

*/

#ifndef PRSVIEWLOGSCREEN_H
#define PRSVIEWLOGSCREEN_H

#include "DataController.h"
#include "Inputs.h"

/**
@brief shows previously logged pressure data on the LCD screen\n
@brief the pressure data is displayed in a convenient way by use of
@brief a data controller
@author Augustine K Kizito
@date April 2015
*/

class PrsViewLogScreen : public DataController
{
private:

    void onEnter(); // user pressed the enter button
    void onBack(); // user pressed the back button

public:
    /**
    Creates an instance of the Pressure View Log Screen
    
    */
    PrsViewLogScreen()
        :DataController( "/local/prs.cfg", // File location
                         0) // parameter, 1 for temperatue, 0 for pressure
    {};
    /**
    Manages the execution of the Pressure View Log Screen
    
    @returns
    
    -1 - Navigate to previous screen
    */
    int start(); 


};










int PrsViewLogScreen::start()
{
    enterButton.mode(PullDown);
    backButton.mode(PullDown);
    
    enterButton.rise(this,&PrsViewLogScreen::onEnter); // call onEnter when the enter button is pressed
    backButton.rise(this,&PrsViewLogScreen::onBack); // call onBack when the back button is pressed
    
    debounce.start();
    
    // launch the data controller
    DataController::begin();

    enterButton.rise(NULL);
    backButton.rise(NULL);
    return -1;
}

void PrsViewLogScreen::onEnter()
{
   if (debounceSuccess()) { // check if debouncing succeeded
        // sound the buzzer
        playSound();
        DataController::nextPage(); 
        debounce.reset(); // reset the debounce timer
    }  

}

void PrsViewLogScreen::onBack()
{
    if (debounceSuccess()) { // check if debouncing succeeded
        // sound the buzzer
        playSound();
        DataController::previousPage();
        debounce.reset(); // reset the debounce timer
    }
}

#endif