#ifndef SOLARICON_H
#define SOLARICON_H

class SolarIcon
{
public:
    SolarIcon(uint8_t xCoordinate,  uint8_t yCoordinate, uint16_t backgroundColor );
    void drawSolarIcon();
    void animateSolarIcon(bool solarStatus);

private:
    uint8_t startingWidth; // x coordinate of the centre of the sun (yello circle)
    uint8_t startingHeight; // y coordinate of the centre of the sun
    uint16_t bgColor;
    uint16_t linesColor; // color of the lines on the solar panel
    int solarRayCounter;
    bool solarIconAnimating;

    void drawRays(uint16_t color);
    void animateRays();
};

SolarIcon::SolarIcon(uint8_t xCoordinate,uint8_t yCoordinate,uint16_t backgroundColor)
                    : solarRayCounter(1),solarIconAnimating(false)
{
    // set the centre of the sun (yellow circle)
    startingWidth = xCoordinate + 40;
    startingHeight = yCoordinate + 18;

    bgColor = backgroundColor;

    // determine the color of the lines on the solar panel
    if (bgColor == ST7735_WHITE ) {
        linesColor = ST7735_BLACK;
    } else if (bgColor == ST7735_BLACK) {
        linesColor = ST7735_WHITE;
    }

}

void SolarIcon::drawSolarIcon()
{

    // draw a small yellow circle
    tft.fillCircle(startingWidth, startingHeight, 7, ST7735_YELLOW);

    // draw the solar panel

    // draw a triangle to the right
    tft.fillTriangle(startingWidth, startingHeight, startingWidth, startingHeight +30, startingWidth +10, startingHeight + 30, ST7735_BLUE);

    // draw rectangle
    tft.fillRect(startingWidth-30, startingHeight, 30, 31, ST7735_BLUE);

    // draw a triangle to the left
    //tft.fillTriangle(startingWidthTwo-30, startingHeightTwo, startingWidthTwo, startingHeightTwo +30, startingWidthTwo - 40, startingHeightTwo + 30, ST7735_BLUE);
    tft.fillTriangle(startingWidth-30, startingHeight, startingWidth-30, startingHeight +30, startingWidth - 40, startingHeight + 30, ST7735_BLUE);

    // draw horizontal lines
    tft.drawFastHLine(startingWidth-32, startingHeight+8,35,linesColor);
    tft.drawFastHLine(startingWidth-36, startingHeight+20,43,linesColor);
    //tft.drawFastHLine(startingWidthTwo-32, startingHeightTwo+8,35,ST7735_WHITE);

    // draw vertical lines
    tft.drawLine(startingWidth-10, startingHeight, startingWidth-2, startingHeight + 30,linesColor);
    tft.drawLine(startingWidth-19, startingHeight, startingWidth-27, startingHeight + 30,linesColor);
    //tft.drawFastVLine(startingWidthTwo-22, startingHeightTwo,31,ST7735_WHITE);


    // draw solar rays
    drawRays(ST7735_YELLOW);

}

void SolarIcon::animateSolarIcon(bool solarStatus)
{

    // if panel is receiving solar radiation
    if (solarStatus) {
        // check if already animating
        if(!solarIconAnimating) {
            // first delete all solar rays
            drawRays(bgColor);
            // solarIcon is now animating
            solarIconAnimating = true;
            // set the ray counter to 1
            solarRayCounter = 1;
            // call the animateray
            animateRays();

        } else {
            // call animateray
            animateRays();
        }

    } else {
        // check if it was animating
        if(solarIconAnimating) {
            // show all the rays
            drawRays(ST7735_YELLOW);
            // set the ray counter to 1
            solarRayCounter = 1;
            // set solarIcon animate to false
            solarIconAnimating = false;
        } else {
            // do nothing
        }

    }

}

void SolarIcon::drawRays(uint16_t color)
{
    // draw solar rays
    tft.drawLine(startingWidth-7, startingHeight-8, startingWidth-12, startingHeight-13,color);
    tft.drawLine(startingWidth, startingHeight-12, startingWidth, startingHeight-18,color);
    tft.drawLine(startingWidth+7, startingHeight-8, startingWidth+12, startingHeight-13,color);
    tft.drawLine(startingWidth+10, startingHeight, startingWidth+17, startingHeight,color);
    tft.drawLine(startingWidth+7, startingHeight+8, startingWidth+12, startingHeight+13,color);
}

void SolarIcon::animateRays()
{
    if (solarRayCounter == 1) {
        // draw the first ray
        tft.drawLine(startingWidth-7, startingHeight-8, startingWidth-12, startingHeight-13,ST7735_YELLOW);
    } else if (solarRayCounter == 2) {
        // draw the second ray
        tft.drawLine(startingWidth, startingHeight-12, startingWidth, startingHeight-18,ST7735_YELLOW);
    } else if (solarRayCounter == 3) {
        // draw the third ray
        tft.drawLine(startingWidth+7, startingHeight-8, startingWidth+12, startingHeight-13,ST7735_YELLOW);
    } else if (solarRayCounter == 4) {
        // draw the fourth ray
        tft.drawLine(startingWidth+10, startingHeight, startingWidth+17, startingHeight,ST7735_YELLOW);
    } else if (solarRayCounter == 5) {
        // draw the fifth ray
        tft.drawLine(startingWidth+7, startingHeight+8, startingWidth+12, startingHeight+13,ST7735_YELLOW);
    } else if (solarRayCounter == 6) {
        // delete arrays
        drawRays(bgColor);
    }

    // increase the counter accordingly
    solarRayCounter++;

    // reset the counter if necessary
    if (solarRayCounter > 6) {
        solarRayCounter = 1;
    }
}

#endif