#ifndef LOGSELECTSCREEN_H
#define LOGSELECTSCREEN_H

#include "ListController.h"

class LogSelectScreen: public Button <LogSelectScreen>
{
public:
    LogSelectScreen(uint16_t backgroundColor);
    int start();
    void buttonPressed(int button);

private:
    void drawLogSelectScreen();
    int changeScreen;  
    ListController *list;  // manages the list
    bool scroll;    // updated when a scroll event occurs
    bool enter;     // updated when an enter event occurs
    uint16_t bgColor;    // background color
    
};

LogSelectScreen::LogSelectScreen(uint16_t backgroundColor)
{
     bgColor = backgroundColor;
    
}

int LogSelectScreen::start(){
    
    // draw the screen
    drawLogSelectScreen();
    
    // attach interrupts to buttons
    Button<LogSelectScreen>::activateButtons(this);
    
    changeScreen = 0;
    scroll = false;
    enter = false;
    
    
    while (changeScreen == 0){
        //updateTile();
        
        // scroll event occured
        if (scroll)
        {
            // perfrom scroll on the list
            list->scroll();
            // reset variable
            scroll = false;    
        }
        
        // enter event occured
        if (enter)
        {
            // read the current option on the list
            changeScreen = list->getCurrentOption();    
        }
        
        //wait_ms(500);
        Thread::wait(200);    
    }
    
    // relese memory occupied by list
    delete list;
    
    // dettach interrupts to buttons
    Button<LogSelectScreen>::deActivateButtons();
    
    return changeScreen;
}

void LogSelectScreen::drawLogSelectScreen(){
       
    // construct the list
    list = new ListController( 0,
                     0,
                   "Parameter",
                "Solar",
                "Power Usage",
                "",
                "",
                bgColor,
                2);
    
    // draw the list 
    list->drawList();   
}

void LogSelectScreen::buttonPressed(int button)
{
    switch(button){
        
        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;
        
        case SCROLLBUTTON:
            // scroll to the next option
            scroll = true;
            break;
        
        case ENTERBUTTON:
            // navigate to the selected option
            enter = true;
            break;
            
        default:
            // do nothing
            break;    
    }
}

#endif