#ifndef LOGSCREEN_H
#define LOGSCREEN_H

#include "ListController.h"

class LogScreen: public Button <LogScreen>
{
public:
    LogScreen(uint16_t backgroundColor);
    int start();
    void buttonPressed(int button);

private:
    void drawLogScreen();
    int changeScreen;  
    ListController *list;   // manages the list
    bool scroll;    // updated when a scroll event occurs
    bool enter;     // updated when an enter event occurs
    uint16_t bgColor;   // stores the background color;
};

LogScreen::LogScreen(uint16_t backgroundColor)
{
    bgColor = backgroundColor;
    
}

int LogScreen::start(){
    
    // draw the screen
    drawLogScreen();
    
    // attach interrupts to buttons
    Button<LogScreen>::activateButtons(this);
    
    changeScreen = 0;
    scroll = false;
    enter = false;
    
    
    while (changeScreen == 0){
 
        
        // scroll event occured
        if (scroll)
        {
            // perform scroll on the list
            list->scroll();
            // reset variable
            scroll = false;    
        }
        
        // enter event occured
        if (enter)
        {
            // read the current option on the list
            changeScreen = list->getCurrentOption();
        }
        //wait_ms(500);
        Thread::wait(200);    
    }
    
    // release the memory held by the list
    delete list;
    
    // dettach interrupts to buttons
    Button<LogScreen>::deActivateButtons();
    
    return changeScreen;
}

void LogScreen::drawLogScreen(){
       
    // construct the list
    list = new ListController( 0,
                     0,
                   "Logs",
                "View Logs",
                "New Logs",
                "Delete Logs",
                "",
                bgColor,
                3);
    
    // draw the list 
    list->drawList();   
}

void LogScreen::buttonPressed(int button)
{
    switch(button){
        
        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;
        
        case SCROLLBUTTON:
            // scroll to the next option
            scroll = true;
            break;
        
        case ENTERBUTTON:
            // navigate to the selected option
            enter = true;
            break;
            
        default:
            // do nothing
            break;    
    }
}

#endif