#ifndef DELETELOGSCREEN_H
#define DELETELOGSCREEN_H

#include "LogManager.h"

class DeleteLogScreen: public Button <DeleteLogScreen>
{
public:
    DeleteLogScreen(uint16_t backgroundColor); // constructor
    int start();
    void buttonPressed(int button);
private:   
    void getLogRecords();    // this function fills the Log Array with records available
    void displayRecords();  // displays the available records
    void deleteRecord(int id);  // deletes the selected record
    void emptyRecords();    // empty the array that stores the records
    ListController *list;   // this is the list used to display the logs
    LogRecord records[4];      // array that stores a maximum of 4 log records
    int numberOfRecords;    // stores the number of records to show
    int changeScreen;
    uint16_t backgroundColor;   // stores the background color
    // updated when a scroll event occurs
    bool scroll;
    // updated when an enter event occurs
    bool enter;
    
};

DeleteLogScreen::DeleteLogScreen(uint16_t bgColor)
{
    backgroundColor = bgColor;
}

int DeleteLogScreen::start()
{
    // retireves the Log Records
    getLogRecords();
    // display those records on a list controller
    displayRecords();

    // attach interrupts to buttons
    Button<DeleteLogScreen>::activateButtons(this);
    
    changeScreen = 0;
    scroll = false;
    enter = false;

    // have the infinite while loop that waits for an event
    while (changeScreen == 0) {
        
        // scroll event occured
        if (scroll)
        {
            // perform scroll on the list  
            list->scroll();
            // reset the variable 
            scroll = false; 
             
        }
        
        // enter event occured
        if (enter)
        {
            // delete the appropriate record 
            deleteRecord(list->getCurrentOption());
            changeScreen = -1;
        }
        
        //wait_ms(500);
        Thread::wait(200);   
    }

    // release memory back to heap
    delete list;
    
    // empty records
    emptyRecords();

    // dettach interrupts to buttons
    Button<DeleteLogScreen>::deActivateButtons();

    return changeScreen;
}

void DeleteLogScreen::getLogRecords()
{

    // create a Log Manager object
    // send the reference of the records array and Log Manager
    // will fill it with available records
    // it returns the number of records availble
    LogManager manager;
    numberOfRecords = manager.retrieveLog(records);
    
    // arrange records with according to time. The latest record first
    if(numberOfRecords > 1) {       
        for(int i = 0; i < (numberOfRecords-1); i++) {
            // compare a given record with all proceding records
            for( int j = 0; j < (numberOfRecords-1); j++) {     
                // check if the time of recording is earlier than the record of interest
                if(records[i].getTimeStamp() < records[j+1].getTimeStamp()) {
                    // swap records
                    LogRecord record = records[i];
                    records[i] = records[j+1];
                    records[j+1] = record;
                }
            }
        }

    }   

    // use the data to construct a list controller with the data
}

void DeleteLogScreen::displayRecords()
{

    myled2 = 1;
    list = new ListController( 0,
                               0,
                               "Logs",
                               records[0].getName(),
                               records[1].getName(),
                               records[2].getName(),
                               records[3].getName(),
                               backgroundColor,
                               numberOfRecords);
                               

    list->drawList();

}

void DeleteLogScreen::deleteRecord(int id)
{
    // deletes the record in the id
    
    LogManager manager;
    manager.deleteLog(records[id-1]);
}

void DeleteLogScreen::emptyRecords()
{
    
    for(int i = 0; i < 4; i++)
    {
        LogRecord record;   // empty record
        records[i] = record;    // store empty record    
    }   
    
    numberOfRecords = 0;    // there are now no records left 
}

void DeleteLogScreen::buttonPressed(int button)
{
    switch(button) {

        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;

        case SCROLLBUTTON:
            // scroll to the next option
            scroll = true;
            break;

        case ENTERBUTTON:
            // navigate to the selected option
            //changeScreen = ListController::getCurrentOption();
            enter = true;
            break;

        default:
            // do nothing
            break;
    }
}
#endif