#ifndef OUTPUTICON_H
#define OUTPUTICON_H

class OutputIcon
{
public:
    OutputIcon(uint8_t xCoordiate, uint8_t yCoordinate, uint16_t backgroundColor);
    void drawOutputIcon();
    void animateOutputIcon(bool outputing);

private:    
    uint8_t startingWidth; // x coordinate of the centre of large circle
    uint8_t startingHeight; // y coordinate of the centre of large circle
    uint16_t bgColor;
    uint16_t drawColor;
    int colorCounter;
    bool outputIconAnimating;
    
    void drawFilledRectangles();
    void animateRectangles();
    
};

OutputIcon::OutputIcon(uint8_t xCoordinate, uint8_t yCoordinate, uint16_t backgroundColor)
                : colorCounter(1),outputIconAnimating(false)
{
    // set the centre of the big circle
    startingWidth = xCoordinate + 31;
    startingHeight = yCoordinate + 17;

    bgColor = backgroundColor;

    // determine the color of the lines on the solar panel
    if (bgColor == ST7735_WHITE ) {
        drawColor = ST7735_BLACK;
    } else if (bgColor == ST7735_BLACK) {
        drawColor = ST7735_WHITE;
    }

    
}

void OutputIcon::drawOutputIcon()
{
    // draw big circle
    tft.fillCircle(startingWidth, startingHeight, 17, drawColor);

    // draw deleting rectangle to cut the circle in half
    tft.fillRect(startingWidth, startingHeight-17,18, 35, bgColor);

    // draw rectangle extension of half circle
    tft.fillRect(startingWidth, startingHeight-17,5,35, drawColor);

    // draw pin one
    tft.fillRect(startingWidth+5, startingHeight-10,12,5, drawColor);

    // draw pin two
    tft.fillRect(startingWidth+5, startingHeight+7, 12, 5, drawColor);

    // draw a small rounnd rectangle at the back of the circle
    tft.fillRoundRect(startingWidth-19, startingHeight-5,12,10,2, drawColor);

    // draw empty rectangle one
    tft.drawRect(startingWidth-23, startingHeight-4,5,8,drawColor);

    // draw empty rectangle two
    tft.drawRect(startingWidth-27, startingHeight-4,5,8,drawColor);

    // draw empty rectangle three
    tft.drawRect(startingWidth-31, startingHeight-4,5,8,drawColor);

    // draw the filled rectangles
    drawFilledRectangles();
}

void OutputIcon::animateOutputIcon(bool outputing)
{
    // check if any device is drawing power (outputing)
    if (outputing) {
        
        // check if the output icon is not animating
        if (!outputIconAnimating) {

            // the output icon is now animating
            outputIconAnimating = true;

            // set to the second color arrangement
            colorCounter = 2;

            // animate the filled rectangles
            animateRectangles();
        } else {

            // continue animation
            animateRectangles();

        }
    } else {

        //check if output icon is animating
        if (outputIconAnimating) {
            // reset all the colors
            drawFilledRectangles();
            // stop any future animation
            outputIconAnimating = false;
        } else {
            // do nothing
        }

    }
    
}

void OutputIcon::drawFilledRectangles()
{
    // fill rectangle one
    tft.fillRect(startingWidth-22, startingHeight-3,3,6,ST7735_GREEN);

    // fill rectangle two
    tft.fillRect(startingWidth-26, startingHeight-3,3,6,ST7735_YELLOW);

    // fill rectangle three
    tft.fillRect(startingWidth-30, startingHeight-3,3,6, ST7735_RED);
}

void OutputIcon::animateRectangles()
{
    if(colorCounter == 1) {
        // green
        // yellow
        // red
        drawFilledRectangles();
    } else if (colorCounter == 2) {
        // red
        // green
        // yellow
        
        // fill rectangle one
        tft.fillRect(startingWidth-22, startingHeight-3,3,6,ST7735_RED);

        // fill rectangle two
        tft.fillRect(startingWidth-26, startingHeight-3,3,6,ST7735_GREEN);

        // fill rectangle three
        tft.fillRect(startingWidth-30, startingHeight-3,3,6, ST7735_YELLOW);
    } else if (colorCounter == 3) {
        // yellow
        // red
        // green
        
        // fill rectangle one
        tft.fillRect(startingWidth-22, startingHeight-3,3,6,ST7735_YELLOW);

        // fill rectangle two
        tft.fillRect(startingWidth-26, startingHeight-3,3,6,ST7735_RED);

        // fill rectangle three
        tft.fillRect(startingWidth-30, startingHeight-3,3,6, ST7735_GREEN);
    } 

    // increase the color counter accordingly
    colorCounter++;

    // make sure color counter stays within range
    if (colorCounter > 3) {
        colorCounter = 1;
    }

}
#endif