#ifndef SOLARGRAPHSCREEN_H
#define SOLARGRAPHSCREEN_H

#include "GraphController.h"

class SolarGraphScreen:public GraphController, public Button <SolarGraphScreen>
{
public:
    SolarGraphScreen(uint16_t backgroundColor);
    int start();
    void buttonPressed(int button);

private:
    int changeScreen; 
};

SolarGraphScreen::SolarGraphScreen(uint16_t backgroundColor)
    :GraphController( backgroundColor,
                   "Power[W] vs Time[s]")
{
    
}

int SolarGraphScreen::start(){
    
    // draw the graph
    GraphController::drawAxes(); 
    
    // attach interrupts to buttons
    Button<SolarGraphScreen>::activateButtons(this);
    
    changeScreen = 0;
    
    
    while (changeScreen == 0){
        GraphController::plotData();
        //wait_ms(100);
        Thread::wait(100);    
    }
    
    // dettach interrupts to buttons
    Button<SolarGraphScreen>::deActivateButtons();
    
    return changeScreen;
}

void SolarGraphScreen::buttonPressed(int button)
{
    switch(button){
        
        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;
        
        case SCROLLBUTTON:
            // scroll to the next option
            //ListController::scroll();
            break;
        
        case ENTERBUTTON:
            // navigate to the selected option
            //changeScreen = ListController::getCurrentOption();
            
        default:
            // do nothing
            break;    
    }
}
#endif