#ifndef RASPISERIAL_H
#define RASPISERIAL_H
#include "MbedJSONValue.h"
#include "MODSERIAL.h"
#include <string>
MODSERIAL raspi(p28, p27); // tx, rx
DigitalOut piPin(p7);

// this function determines wherther serial is active or inactive

// this function manages communication between raspberry pi and mbed

void raspiSerial()
{
    //determines whether serial data should started/stopped
    bool serialStatus;

    // data to track the status of the pi
    bool piStatus = false;              // determines the current serial connection
    bool cameraStatus = false;         // determines whether the camera is active
    bool cloudStatus = false;         // detemines when the pi is connected to the cloud
    bool detectionStatus =false;     // determines whether the object detection system is functional


    // define variables to store sensor data
    float b1Voltage = 0.0;
    float b1Current = 0.0;
    float b2Voltage = 0.0;
    float b2Current = 0.0;
    float sVoltage = 0.0;
    float sCurrent = 0.0;
    float oVoltage = 0.0;
    float oCurrent = 0.0;

    // define string to store rounded off sensor data
    char b1VoltageString[5];
    char b1CurrentString[5];
    char b2VoltageString[5];
    char b2CurrentString[5];
    char sVoltageString[5];
    char sCurrentString[5];
    char oVoltageString[5];
    char oCurrentString[5];

    // get access to the sensor suite
    SensorSuite suite;
 

    // power up the raspberry pi
    piPin = 1;

    // give the pi some time to boot
    //Thread::wait(1000*10);
    
    // wait for character x
    int counter = 180;  // count down to 3 minutes
    char x = NULL;
    while(counter > 0 && x != 'x') {
        x = raspi.getc();
        Thread::wait(1000);
        counter--;
    }

    if (x == 'x') {
        myled = 1;
        piStatus = true;
        // send message that connection was made
        serial_ui_letter *letter2 = serial_ui_mail.alloc();
        letter2->piStat = piStatus;
        letter2->camStat = cameraStatus;
        letter2->cloudStat = cloudStatus;
        letter2->detectionStat = detectionStatus;
        serial_ui_mail.put(letter2);
    }



    // open the serial port

    // start with an infinite loop
    while(true) {

        /////////////////// Check for any new messages /////////////////////////


        osEvent evt = ui_serial_mail.get(0);
        if(evt.status == osEventMail) {
            ui_serial_letter *letter = (ui_serial_letter*)evt.value.p;
            // update the serial status
            serialStatus = letter->activateSerial;
            // delete the message
            ui_serial_mail.free(letter);
        }

        if(!serialStatus)
            break;          // means that the user requested the rpi to be turned off

        ////////////////////////////////////////////////////////////////////////

        ///////////////// read data from the sensor suite //////////////////////

        // create model to get battery data
        BatteryModel bModel = suite.getBatteryData();
        // read battery data
        b1Voltage = bModel.batteryOneVoltage;
        b1Current = bModel.batteryOneCurrent;
        b2Voltage = bModel.batteryTwoVoltage;
        b2Current = bModel.batteryTwoCurrent;

        // create model to get solar data
        SolarModel sModel = suite.getSolarData();
        // read solar panel data
        sVoltage = sModel.solarVoltage;
        sCurrent = sModel.solarCurrent;
        
        
        
        // create model to get consumption data
        ConsumptionModel oModel = suite.getConsumptionData();
        // read the consumption data
        oVoltage = oModel.consumptionVoltage;
        oCurrent = oModel.consumptionCurrent;
        
        

        ////////////////////////////////////////////////////////////////////////

        /////////////////////// package data into json string //////////////////

        // create JSON object
        MbedJSONValue holder;
        // create string to store data
        std::string jsonString;

        // round off sensor data to 2 decimal places
        sprintf(b1VoltageString,"%0.2f",b1Voltage);
        sprintf(b1CurrentString,"%0.2f",b1Current);
        sprintf(b2VoltageString,"%0.2f",b2Voltage);
        sprintf(b2CurrentString,"%0.2f",b2Current);
        sprintf(sVoltageString,"%0.2f",sVoltage);
        sprintf(sCurrentString,"%0.2f",sCurrent);
        sprintf(oVoltageString,"%0.2f",oVoltage);
        sprintf(oCurrentString,"%0.2f",oCurrent);

        // construct json data
        holder["b1V"] = b1VoltageString;
        holder["b1C"] = b1CurrentString;
        holder["b2V"] = b2VoltageString;
        holder["b2C"] = b2CurrentString;
        holder["sV"]  = sVoltageString;
        holder["sC"]  = sCurrentString;
        holder["oV"]  = oVoltageString;
        holder["oC"]  = oCurrentString;

        // convert json data to string
        jsonString = holder.serialize();
        ////////////////////////////////////////////////////////////////////////

        //////////////////////// send data to raspberry pi /////////////////////

        // write data onto the serial port
        raspi.printf("%s\n", jsonString.c_str());

        ////////////////////////////////////////////////////////////////////////
        /**
        ////////// receive confirmation from the raspberry pi///////////////////

        // create json object
        MbedJSONValue demo;

        // variables to read data
        int i = 0;
        bool completed = false;
        
        char rxString[80]; // buffer that stores received string


        // read the first character
        char receivedChar = raspi.getc();
        while (!completed) {
            // Check if it's a new line character
            if (receivedChar != '\n') {
                // if not store in buffer
                rxString[i] = receivedChar;
                i++;
                // read the next character
                receivedChar = raspi.getc();
            } else {
                // the character was a newline character
                completed = true;
            }
        }



        //convert the buffer data into a json string
        const char *json = rxString;

        // parse the json string
        parse(demo, json);

        // retrieve the desired data
        cameraStatus = demo["pS"].get<bool>();
        cloudStatus = demo["caS"].get<bool>();
        detectionStatus = demo["clS"].get<bool>();

        // empty the buffer here
        raspi.rxBufferFlush();

        ////////////////////////////////////////////////////////////////////////

        /////////////////// send the data to the ui thread //////////////////////

        serial_ui_letter *letter2 = serial_ui_mail.alloc();
        letter2->piStat = piStatus;
        letter2->camStat = cameraStatus;
        letter2->cloudStat = cloudStatus;
        letter2->detectionStat = detectionStatus;
        serial_ui_mail.put(letter2);

        /////////////////////////////////////////////////////////////////////////
        
        **/

        /////////// wait a certain amount of time before proceeding/////////////

        //**** remember  to convert floats to characters to save space on buffer***
        Thread::wait(2000); // one second
    }

    ////////////////// sequence that shuts down the raspberry pi ///////////////
    
    raspi.rxBufferFlush();  // empty the receive buffer

    counter = 120; // reset the counter to 2 minutes
    char p = NULL;
    raspi.putc('x');
    raspi.putc('\n'); // new line character
    while(p != 'x'&& counter != 0) {
        raspi.putc('x');
        raspi.putc('\n'); // new line character
        Thread::wait(1000);
        p = raspi.getc();
        Thread::wait(1000);
        counter--;
    }
    
    if (p == 'x') {
        Thread::wait(1000*12);// wait 12 seconds
        piPin = 0;
        myled = 0;
        piStatus = false;
        // send message that connection was made
        serial_ui_letter *letter2 = serial_ui_mail.alloc();
        letter2->piStat = piStatus;
        letter2->camStat = cameraStatus;
        letter2->cloudStat = cloudStatus;
        letter2->detectionStat = detectionStatus;
        serial_ui_mail.put(letter2);
    }

    // remember to give the pi some time to shut down

    ////////////////////////////////////////////////////////////////////////////
}

#endif