#include "mbed.h"
#include "rtos.h"
#include "MbedJSONValue.h"
#include <string>
#include "Outputs.h"
#include "MailBoxes.h"
#include "SensorSuite.h"


DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut relayOne(p26);
DigitalOut relayTwo(p25);
DigitalOut relayThree(p24);
DigitalOut backlight(p17);




#define OFF 1
#define ON 0


uint16_t backgroundColor = ST7735_BLACK;


LocalFileSystem local("local");

//Adafruit_ST7735 tft(p11, p12, p13, p10, p8, p9); // MOSI, MISO, SCLK, SSEL, TFT_DC, TFT_RST

#include "Icons.h"
#include "Inputs.h"
#include "Settings.h"
#include "SettingsTest.h"
#include "LogManager.h"
#include "LogRecord.h"
#include "Screens.h"
#include "RaspiSerial.h"


void createScreens();
void changeBackgroundColor();
bool settingsExist( const char *fname);
void uiThread();
void logThread();
void sensorThread();

uint16_t currentColor;

// ensure that settings are not initialised
bool Settings::settingsInitialised = false;
MbedJSONValue Settings:: holder;    // JSON Data structure to store settings read from file
uint16_t Settings::backgroundColor = 0;

// ensure that sensor data is initialised



MainMenuScreen *menu;
BatteriesScreen *batteriesScreen;
BatteryScreen *battScreen;
SolarScreen *solarScreen;
OutputScreen *outputScreen;
SettingsScreen *settingsScreen;
SolarGraphScreen *solarGraphScreen;
SolarValueScreen *solarValueScreen;
TestScreen *test;
LogScreen *logg;
LogSelectScreen *logSelect2;
LogSelectScreen *logSelect1;
LogDurationScreen *logDuration;
LogDurationScreen *logDuration2;
ViewLogScreen *viewLog;
DeleteLogScreen *deleteLog;
LogManager *log1;
RaspberryPiScreen *rpiScreen;
UtilityScreen   *utilityScreen;
//LogManager *log2;
Thread loggingThread(osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25), NULL);

int main()
{
    // launch the sensors
    Thread thread(osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25), NULL);
    thread.start(sensorThread);

    // launch the user interface
    // turn on backlight
    

    
    backlight = 1;
    Thread thread2(osPriorityNormal, (DEFAULT_STACK_SIZE * 2.25), NULL);
    thread2.start(uiThread);
    


    while(true) {


    }


}

void sensorThread()
{
    SensorSuite suite;
    // launch the sensor suite
    suite.begin();
}

void logThread()
{
    
    LogManager logg;
    // launch the log thread
    logg.createNewLog(logInstructions.parameter,logInstructions.duration);
}

void uiThread()
{
    // set the current time
    set_time(1475252667);
    // Use this initializer if you're using a 1.8" TFT
    tft.initR(INITR_BLACKTAB);   // initialize a ST7735S chip, black tab



    // create the settings object
    Settings settings;
    currentColor = settings.getBackgroundColor();
    backgroundColor = currentColor;

    tft.fillScreen(backgroundColor);
    // landscape view
    tft.setRotation(1);
    createScreens();

    //struct setting lcdBackground;
    //lcdBackground.value = 1;
    //lcdBackground.key = 1;
    //rewind(ptr_myfile);
    //fseek(ptr_myfile,sizeof(struct setting)*0,SEEK_SET);
    //fwrite(&emptySetting, sizeof(struct setting), 1, ptr_myfile);
    //fread(&lcdBackground, sizeof(struct setting), 1, ptr_myfile);







    bool backToFirstLayer = false;
    bool backToSecondLayer = false;
    bool backToThirdLayer = false;
    bool backToFourthLayer = false;

    while(1) {

        int val = menu->start();

        if (val == 1) {

            backToFirstLayer = false;

            while(!backToFirstLayer) {

                switch(batteriesScreen->start()) {

                    case 1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while(!backToSecondLayer) {
                            switch(battScreen->start(BATTERY_ONE)) {
                                case -1:
                                    // clear screen
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    // do nothing
                                    break;
                            }
                        }
                        break;

                    case 2:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while(!backToSecondLayer) {
                            switch(battScreen->start(BATTERY_TWO)) {
                                case -1:
                                    // clear screen
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    // do nothing
                                    break;
                            }
                        }
                        break;

                    case -1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToFirstLayer = true;
                        break;

                    default:

                        break;
                }
            }

        } else  if (val == 2) {

            backToFirstLayer = false;

            while (!backToFirstLayer) {

                switch(outputScreen->start()) {

                    case 1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while(!backToSecondLayer) {
                            switch(rpiScreen->start()) {
                                case -1:
                                    // clear screen
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    // do nothing
                                    break;
                            }
                        }

                        break;

                    case 2:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while(!backToSecondLayer) {
                            switch(utilityScreen->start()) {
                                case -1:
                                    // clear screen
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    // do nothing
                                    break;
                            }
                        }

                        break;

                    case -1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToFirstLayer = true;
                        break;

                    default:
                        // do nothing
                        break;
                }
            }
        } else if (val == 3) {

            backToFirstLayer = false;

            while(!backToFirstLayer) {

                switch(solarScreen->start()) {

                    case 1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while(!backToSecondLayer) {
                            switch(solarValueScreen->start()) {
                                case -1:
                                    // clear screen
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    // do nothing
                                    break;

                            }
                        }
                        break;

                    case 2:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while(!backToSecondLayer) {
                            switch(solarGraphScreen->start()) {
                                case -1:
                                    // clear screen
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    // do nothing
                                    break;

                            }
                        }
                        break;
                    case -1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToFirstLayer = true;
                        break;

                    default:
                        // do nothing
                        break;
                }
            }

        } else if (val == 4) {

            backToFirstLayer = false;

            while (!backToFirstLayer) {

                switch(settingsScreen->start()) {
                    case 1:

                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while (!backToSecondLayer) {

                            switch(test->start()) {
                                case -1:
                                    // clear screen
                                    // first check if the background color was changed
                                    // then change the background colors
                                    changeBackgroundColor();
                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                            }
                        }
                        break;
                    case 2:

                        // clear the screen
                        tft.fillScreen(backgroundColor);
                        backToSecondLayer = false;

                        while (!backToSecondLayer) {

                            switch(logg->start()) {

                                case 1:
                                    // clear the screen
                                    tft.fillScreen(backgroundColor);
                                    backToThirdLayer = false;

                                    while(!backToThirdLayer) {

                                        switch(viewLog->start()) {

                                            case -1:
                                                tft.fillScreen(backgroundColor);
                                                backToThirdLayer = true;
                                                break;

                                        }

                                    }

                                    break;

                                case 2:

                                    // clear the screen
                                    tft.fillScreen(backgroundColor);
                                    backToThirdLayer = false;

                                    while(!backToThirdLayer) {

                                        switch(logSelect2->start()) {

                                            case 1:
                                                // clear the screen
                                                tft.fillScreen(backgroundColor);
                                                backToFourthLayer = false;

                                                while(!backToFourthLayer) {
                                                    switch(logDuration->start()) {

                                                        case 1:
                                                            // start logging for 30 seconds
                                                            tft.fillScreen(backgroundColor);


                                                            // navigate all the way back to log screen
                                                            backToFourthLayer = true;
                                                            backToThirdLayer = true;
                                                            break;
                                                        case 2:
                                                            // start logging for 1 minute
                                                            tft.fillScreen(backgroundColor);


                                                            // navigate all the way to log screen
                                                            backToFourthLayer = true;
                                                            backToThirdLayer = true;
                                                            break;

                                                        case -1:
                                                            // clear the screen
                                                            tft.fillScreen(backgroundColor);
                                                            backToFourthLayer = true;
                                                    }
                                                }
                                                break;
                                            case 2:
                                                // clear the screen
                                                tft.fillScreen(backgroundColor);
                                                backToFourthLayer = false;

                                                while(!backToFourthLayer) {
                                                    switch(logDuration->start()) {

                                                        case 1:
                                                            // start logging for 30 seconds
                                                            //log1 = new LogManager();
                                                            //log1->createNewLog(POWER_CONSUMPTION,THIRTY_SECONDS);
                                                        
                                                            //logInstructions.parameter = POWER_CONSUMPTION;
                                                            //logInstructions.duration = THIRTY_SECONDS;
                                                            //loggingThread.start(logThread);
                                                            
                                                            tft.fillScreen(backgroundColor);
                                                            // navigate all the way back to log screen
                                                            backToFourthLayer = true;
                                                            backToThirdLayer = true;
                                                            break;
                                                        case 2:
                                                            // start logging for 1 minute
                                                            //log1 = new LogManager();
                                                            //log1.createNewLog(ONE_MINUTE,SOLAR_POWER);
                                                            tft.fillScreen(backgroundColor);

                                                            // navigate all the way to log screen
                                                            backToFourthLayer = true;
                                                            backToThirdLayer = true;
                                                            break;

                                                        case -1:
                                                            // clear the screen
                                                            tft.fillScreen(backgroundColor);
                                                            backToFourthLayer = true;
                                                            break;
                                                    }
                                                }
                                                break;

                                            case -1:
                                                tft.fillScreen(backgroundColor);
                                                backToThirdLayer = true;
                                                break;

                                            default:
                                                break;
                                        }
                                    }
                                    break;
                                case 3:
                                    // clear the screen
                                    tft.fillScreen(backgroundColor);
                                    backToThirdLayer = false;

                                    while(!backToThirdLayer) {

                                        switch(deleteLog->start()) {
                                            case -1:
                                                // clear the screen
                                                tft.fillScreen(backgroundColor);
                                                backToThirdLayer = true;
                                                break;
                                        }
                                    }
                                    break;
                                case -1:

                                    tft.fillScreen(backgroundColor);
                                    backToSecondLayer = true;
                                    break;
                                default:
                                    break;
                            }
                        }
                        break;
                    case -1:
                        // clear screen
                        tft.fillScreen(backgroundColor);
                        backToFirstLayer = true;
                        break;
                }

            }

        }
        tft.fillScreen(backgroundColor);
    }


}




void changeBackgroundColor()
{
    Settings settings;
    if (currentColor != settings.getBackgroundColor()) {
        currentColor = settings.getBackgroundColor();
        backgroundColor = currentColor;

        // delete all the pointer
        delete menu;
        delete batteriesScreen;
        delete solarScreen;
        delete outputScreen;
        delete settingsScreen;
        delete solarGraphScreen;
        delete test;
        delete logg;
        delete logSelect2;
        delete logDuration;
        delete viewLog;
        delete deleteLog;
        delete battScreen;
        delete solarValueScreen;
        delete rpiScreen;
        delete utilityScreen;

        // create new screens
        createScreens();

    }

}

void createScreens()
{
    menu  = new MainMenuScreen(backgroundColor);
    batteriesScreen = new BatteriesScreen(backgroundColor);
    solarScreen = new SolarScreen(backgroundColor);
    outputScreen = new OutputScreen(backgroundColor);
    settingsScreen = new SettingsScreen(backgroundColor);
    solarGraphScreen = new SolarGraphScreen(backgroundColor);
    test = new TestScreen(backgroundColor);
    logg = new LogScreen(backgroundColor);
    logSelect2 = new LogSelectScreen(backgroundColor);
    logDuration = new LogDurationScreen(backgroundColor);
    viewLog = new ViewLogScreen(backgroundColor);
    deleteLog = new DeleteLogScreen(backgroundColor);
    battScreen = new BatteryScreen(backgroundColor);
    solarValueScreen = new SolarValueScreen(backgroundColor);
    rpiScreen = new RaspberryPiScreen(backgroundColor);
    utilityScreen = new UtilityScreen(backgroundColor);
}

