#ifndef TESTSCREEN_H
#define TESTSCREEN_H

#include "ListController.h"
#include "Settings.h"

// On board LEDS
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);



class TestScreen: public Button <TestScreen>
{

public:
    TestScreen(uint16_t backgroundColor);
    int start();
    void createController(uint16_t backgroundColor);
    void buttonPressed(int button);
    void changeColor( int level);

private:

    void drawTestScreen();
    //void deAllocateMemory();
    void intialiseSettings();
    
    int bgC;
    int colorInt;
    MbedJSONValue holder;
    uint16_t bgColor;

    int changeScreen;
    float previousWattage;
    ListController *controller;
    bool writeFlag;
    bool scroll;
    bool enter;

};


TestScreen::TestScreen(uint16_t backgroundColor)
{

}

void TestScreen::intialiseSettings()
{
    // create the settings object
    Settings settings;
    bgColor = settings.getBackgroundColor();
}


int TestScreen::start()
{
    // initialise settings
    intialiseSettings();

    switch (bgC) {
        case 1:
            bgColor = ST7735_BLACK;
            break;
        case 2:
            bgColor = ST7735_WHITE;
    }

    createController(bgColor);

    writeFlag = false;
    drawTestScreen();
    // attach interrupts to buttons
    Button<TestScreen>::activateButtons(this);

    changeScreen = 0;

    while (changeScreen != -1) {

        if (writeFlag) {
            
            // create settings object
            Settings settings;
            // set the new backgroundColor
            // it is saved in memory
            settings.setBackgroundColor(colorInt);

            writeFlag = false;
        }
        
        if (scroll) {
            
            controller->scroll();
            scroll = false;
        }
        
        if (enter) {
            changeScreen = controller->getCurrentOption();
            changeColor(changeScreen);
            enter = false;
        }
        //wait_ms(500);
        Thread::wait(200);   
    }

    // dettach interrupts to buttons
    Button<TestScreen>::deActivateButtons();

    // release memory
    delete controller;

    return changeScreen;
}


void TestScreen::drawTestScreen()
{
    // draw the list
    controller->drawList();
}

void TestScreen::changeColor(int level)
{   
    // first release the memory occupied by the current controller
    delete controller;
    
    // will store the new color
    uint16_t bg;
    
    // determine the new background color
    switch(level) {
        // integer 1 is for black background
        case 1:
            bg = ST7735_BLACK;
            break;
        // integer 2 is for white background
        case 2:
            bg = ST7735_WHITE;
            break;
        default:
            break;

    }
    
    // create a new controller with new background color
    createController(bg);
    
    // draw the controller
    controller->drawList();
    
    // set the color variable
    colorInt = level;
    
    // raise flag so that settings are saved in persistent memory
    writeFlag = true;
}

void TestScreen::createController(uint16_t bg)
{
    controller = new ListController( 0,
                                     0,
                                     "Background",
                                     "Black",
                                     "White",
                                     "",
                                     "",
                                     bg,
                                     2);
}

void TestScreen::buttonPressed(int button)
{
    switch(button) {

        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;

        case SCROLLBUTTON:
            // scroll to the next option
            scroll = true;
            break;

        case ENTERBUTTON:
            // navigate to the selected option
            enter = true;

        default:
            // do nothing
            break;
    }
}

#endif


