#ifndef SETTINGS_H
#define SETTINGS_H

class Settings
{

public:
    Settings();
    void setBackgroundColor(int);
    uint16_t getBackgroundColor();
    void setLCDBrightness(double);
    float getLCDBrightness();

private:
    void initialiseSettings();  // intialises the settings
    
    bool settingsExist(const char *fname);  // checks whether the setting file exists
    
    static MbedJSONValue holder;    // JSON Data structure to store settings read from file
    static uint16_t backgroundColor;  //
    static float LCDBrightness; // tracks the LCDBrightness
    static bool settingsInitialised;    // tracks if settings have already been created
};


Settings::Settings()
{
    // initialise the settings first

    // remember to set the varaible to false
    if (!settingsInitialised) {
        initialiseSettings();
        settingsInitialised = true;
    }
}

void Settings::initialiseSettings()
{
    // pointer to the settings file
    FILE *ptr_myfile;

    // buffer to store settings data
    char read_string [256];

    // if the settings file does not exit, create it
    if (!settingsExist("/local/settings.txt")) {

        // create the settings file
        FILE *fp;
        // prepare file for writing
        fp = fopen("/local/settings.txt", "w");

        // create temporary JSON object
        MbedJSONValue temp;

        // construct the settings data
        temp["LCDBrightness"] = 1;
        temp["LCDColor"] = 1;
        temp["Data"] = 1;

        // convert json object to string
        std::string s;
        s = temp.serialize();

        // write settings to file
        fprintf(fp, "%s", s.c_str());

        // close the file
        fclose(fp);
    }

    // prepare the settings file for reading
    ptr_myfile = fopen("/local/settings.txt", "r");

    // read the settings string into buffer
    fgets(read_string,256,ptr_myfile);

    // convert string into JSON Data
    parse(holder,read_string);

    // initialise all the settings

    // LCD Background Color
    int color = holder["LCDColor"].get<int>();
    if (color == 1)
        backgroundColor = ST7735_BLACK;
    else
        backgroundColor = ST7735_WHITE;

    // LCD Brightness

    // close the file
    fclose(ptr_myfile);


}

bool Settings::settingsExist( const char *fname)
{
    FILE *file;
    if (file = fopen(fname, "r")) {
        fclose(file);
        return true;
    }
    return false;
}

void Settings::setBackgroundColor( int num )
{
    // change the background color apropriately
    if (num == 1)
        backgroundColor = ST7735_BLACK;
    else
        backgroundColor = ST7735_WHITE;

    // pointer to access file
    FILE *ptr_myfile;

    // prepare file for writing
    ptr_myfile = fopen("/local/settings.txt", "w");

    // write the new LCD background value in JSON Object
    holder["LCDColor"] = num;

    // convert json data to string
    std::string s;
    s = holder.serialize();

    // write it to the file
    fprintf(ptr_myfile, "%s", s.c_str());

    fclose(ptr_myfile);


}

uint16_t Settings::getBackgroundColor()
{
    // returns the background color
    if (settingsInitialised){
        return backgroundColor;
    }
    
    // blue background is a sign of an error
    return ST7735_BLUE;
}

#endif