#ifndef RECORDSCREEN_H
#define RECORDSCREEN_H

#include "LogRecord.h"

class RecordScreen: public Button <RecordScreen>
{
public:
    RecordScreen(uint16_t bgColor);
    int start(LogRecord r);
    void buttonPressed(int button);
private:
    void displayData(); // displaying static data alone
    //void refreshData(); // refreshes the dynamic data on the screen
    int changeScreen;
    uint16_t backgroundColor;
    LogRecord record;   // record that is going to store the data
    uint16_t textColor;
    
};

RecordScreen::RecordScreen(uint16_t bgColor)
{
    backgroundColor = bgColor;
    
    // determine the color of text
    if (bgColor == ST7735_WHITE ) {
        textColor = ST7735_BLACK;

    } else if (bgColor == ST7735_BLACK) {
        textColor = ST7735_WHITE;
    } else if (bgColor == ST7735_BLUE) {
        textColor = ST7735_WHITE;
    }  
}

int RecordScreen::start(LogRecord rd)
{
    record = rd;
    changeScreen = 0;
    
    // show the static data
    
    displayData();
    
    // attach interrupts to buttons
    Button<RecordScreen>::activateButtons(this);
    
    while(changeScreen == 0)
    {
        //wait_ms(500);
        Thread::wait(200);    
    }
    
    // dettach interrupts to buttons
    Button<RecordScreen>::deActivateButtons();
    
    return changeScreen;
}

void RecordScreen::displayData()
{
    // display parameter
    char parameter[20];
    switch(record.getParameter())
    {
        case SOLAR_POWER:
            strcpy(parameter,"Solar Power(W)");
            break;
        case POWER_CONSUMPTION:
            strcpy(parameter,"Power Consumption(W)");
            break;
        default:
            break;    
    }
    tft.setCursor((tft.width()/2)-50,4);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("%s",parameter);
    
    // display time
    char date[30];
    time_t seconds = record.getTimeStamp();
    strftime(date, 30, "%D %R", localtime(&seconds));
    record.getTimeStamp();
    tft.setCursor(0,22);
    tft.setTextColor(textColor);
    tft.printf("DATE: %s",date);
    
    // display duration
    char duration[20];
    switch(record.getDuration())
    {
        case THIRTY_SECONDS:
            strcpy(duration,"30 seconds");
            break;
        case ONE_MINUTE:
            strcpy(duration,"1 minute");
            break;
        default:
            break;    
    }
    tft.setCursor(0, 42);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("DURATION: %s",duration);
    
    int added = 10;
    // display minimum
    record.getMinimum();
    tft.setCursor(0, 62);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("MIN");
    tft.setCursor(0, 62 + added);
    tft.printf("%.1f",record.getMinimum());
    
    // display average
    record.getAverage();
    tft.setCursor(55, 62);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("AVG");
    tft.setCursor(55, 62 + added);
    tft.printf("%.1f",record.getAverage());
    
    // display maximum
    record.getMaximum();
    tft.setCursor(110, 62);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("MAX");
    tft.setCursor(110, 62 + added);
    tft.printf("%.1f",record.getMaximum());
    
    // display status
    char status[20];
    switch(record.getStatus())
    {
        case 1:
            strcpy(status,"Logging...");
            break;
        
        case 0:
            break;
        default:
            break;    
    }
    tft.setCursor(0, 92);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("STATUS: %s",status);
    
    
    // display timeleft
    record.getPercentage();
    
    // calculate time left
    // this uses the percentage figure to do this
}

void RecordScreen::buttonPressed(int button)
{
    switch(button) {

        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;

        case SCROLLBUTTON:
            // scroll to the next option
            //list->scroll();
            break;

        case ENTERBUTTON:
            // navigate to the selected option
            //changeScreen = ListController::getCurrentOption();
            //showDetails = true;
            break;

        default:
            // do nothing
            break;
    }
}
    
#endif