#ifndef LISTCONTROLLER_H
#define LISTCONTROLLER_H

#include "Inputs.h"

#define OPTION1 1
#define OPTION2 2
#define OPTION3 3
#define OPTION4 4

class ListController
{

public:
ListController(uint8_t xCoord, uint8_t yCoord,char title[], char option1[], char option2[], char option3[], char option4[], uint16_t backgroundColor,int numberOfOptions);
int getCurrentOption();

void drawList();
void scroll();

private:
    int nOOp;
    char t[32];
    char op1[32];
    char op2[32];
    char op3[32];
    char op4[32];
    const char *ops[5][32];
    uint16_t bgColor;
    uint16_t textColor;
    uint16_t highlightColor;
    int currentOption;
    
    // Coordinates
    uint8_t startWidth;
    uint8_t startHeight;

    void drawTitle();
    void drawLines();
    void drawText();
    void drawSmallText(uint8_t x, uint8_t y, char *text);
    void deleteSmallText(uint8_t x, uint8_t y, char *text);
    void drawBigText(uint8_t x, uint8_t y, char *text);
    void deleteBigText(uint8_t x, uint8_t y, char *text);
    void highlightOption( int option);
    void deHighlightOption(int option);

};

ListController::ListController(uint8_t xCoord, uint8_t yCoord,char title[], char option1[], char option2[], char option3[], char option4[], uint16_t backgroundColor,int numberOfOptions)
{
    // list controller first initialiser  
    
    // set the background color
    bgColor = backgroundColor;
    
    // set the texts appropriately
    strcpy(t,title);
    strcpy(op1,option1);
    strcpy(op2,option2);
    strcpy(op3,option3);
    strcpy(op4,option4);
    
    
    /*
    strcpy(t,options[0][0]);
    strcpy(op1,options[1][0]);
    strcpy(op2,options[2][0]);
    strcpy(op3,options[3][0]);
    strcpy(op4,options[4][0]);
    */
    
    // set the coordinates
    startWidth = xCoord;
    startHeight = yCoord;
    
    // set the number of options
    nOOp = numberOfOptions;
    

    // determine the color of text
    if (bgColor == ST7735_WHITE ) {
        textColor = ST7735_BLACK;
        highlightColor = ST7735_RED;
    } else if (bgColor == ST7735_BLACK) {
        textColor = ST7735_WHITE;
        highlightColor = ST7735_CYAN;
    } else if (bgColor == ST7735_BLUE) {
        textColor = ST7735_WHITE;
    }  
}

void ListController::drawList()
{
    // first draw a filled rectangle with the background color
    tft.fillRect(startWidth, startHeight, tft.width(), tft.height()-startHeight, bgColor);

    // draw the title
    drawTitle();

    // then draw the cell demarcating lines
    drawLines();
    
    // then draw the text in each cell
    drawText();
    
    // set the first option as the current opion
    currentOption = OPTION1;
    
    // highlight the first option / first cell
    highlightOption(OPTION1);    
}


void ListController::drawTitle()
{
    // draws the title of the list
    tft.setCursor((tft.width()/2)-30,startHeight+4);
    tft.setTextColor(textColor);
    tft.setTextWrap(true);
    tft.printf("%s",t);    
}


void ListController::drawLines()
{
    // draws the appropriate cell lines
    // these lines demarcate the cell elements
    for (int i = 0; i < nOOp+1; i++){
        tft.drawFastHLine(0,startHeight+15+(20*i), tft.width(),textColor);
    } 
}

void ListController::drawText(){
    // draws the text within the cell elements 
    // ie the options
    
    tft.setTextColor(textColor);
    tft.setTextSize(1);
    
    // option 1
    tft.setCursor(startWidth +20, startHeight + 22);
    tft.printf("%s",op1);
    
    // option 2
    tft.setCursor(startWidth + 20, startHeight + 42);
    tft.printf("%s",op2);
    
    // option 3
    tft.setCursor(startWidth + 20, startHeight + 62);
    tft.printf("%s",op3);
    
    // option 4
    tft.setCursor(startWidth + 20, startHeight + 82);
    tft.printf("%s",op4);
}

int ListController::getCurrentOption()
{
    return currentOption;    
}

void ListController::scroll()
{
    // provides the mechanism that animates 
    // highlighting from one option to the next i.e scrolling
    
    
    // increment the option tracker
    currentOption++;
    
    // remove highlighting from the previous option
    deHighlightOption(currentOption-1);
    
    // ensure the option tracker stays within range
    if (currentOption > nOOp ){
        // set it back to the first option after the
        // last option is reached
        currentOption = 1;    
    }
    
    // hgighlight the new option
    highlightOption(currentOption);    
}

void ListController::highlightOption(int option){
    
    // this function implements the mechanism for
    // highlighting a given option on the list
    
    switch (option){
        case OPTION1:
            // delete the small text
            deleteSmallText(startWidth +20, startHeight + 22,op1);
            // draw the big text
            drawBigText(startWidth+10, startHeight+17,op1);
            break;
        case OPTION2:
            // delete the small text
            deleteSmallText(startWidth + 20, startHeight + 42,op2);
            // draw the big text
            drawBigText(startWidth+10, startHeight+37,op2);
            break;
        case OPTION3:
            // delete the small text
            deleteSmallText(startWidth + 20, startHeight + 62,op3);
            // draw the big text
            drawBigText(startWidth+10, startHeight+57,op3);
            break;
        case OPTION4:
            // delete the small text
            deleteSmallText(startWidth + 20, startHeight + 82,op4);
            // draw the big text
            drawBigText(startWidth+10, startHeight+77,op4);
            break;   
    }    
}

void ListController::deHighlightOption(int option)
{
    // this function implements the mechanism for
    // dehighlighting a given option on the list
    
    switch (option){
        case OPTION1:
            // delete the big text
            deleteBigText(startWidth+10, startHeight+17,op1);
            // draw the small text
            drawSmallText(startWidth +20, startHeight + 22,op1);
            break;
        case OPTION2:
            // delete the big text
            deleteBigText(startWidth+10, startHeight+37,op2);
            // draw the small text
            drawSmallText(startWidth + 20, startHeight + 42,op2);
            break;
        case OPTION3:
            // delete the big text
            deleteBigText(startWidth+10, startHeight+57,op3);
            // draw the small text
            drawSmallText(startWidth + 20, startHeight + 62,op3);
            break;
        case OPTION4:
            // delete the big text
            deleteBigText(startWidth+10, startHeight+77,op4);
            // draw the small text
            drawSmallText(startWidth + 20, startHeight + 82,op4);
            break;   
    }    
}

void ListController::drawSmallText(uint8_t x, uint8_t y, char *text){
    
    // draws small text within a given cell element
    tft.setCursor(x, y);
    tft.setTextColor(textColor);
    tft.printf("%s",text);
    tft.setTextSize(1);
}

void ListController::deleteSmallText(uint8_t x, uint8_t y, char *text){
    
    // deletes small text within a given cell element 
    // by replacing it with background color
    tft.setCursor(x, y);
    tft.setTextColor(bgColor);
    tft.printf("%s",text);
    tft.setTextSize(1);
}

void ListController::drawBigText(uint8_t x, uint8_t y, char *text){
    
    // draws big text within a given cell element 
    tft.setTextSize(2);
    tft.setCursor(x, y);
    tft.setTextColor(highlightColor);
    tft.printf("%s",text);
    tft.setTextSize(1);

}

void ListController::deleteBigText(uint8_t x, uint8_t y, char *text){
    
    // deletes big text within a given cell element
    // by replacing it with background color
    tft.setTextSize(2);
    tft.setCursor(x, y);
    tft.setTextColor(bgColor);
    tft.printf("%s",text);
    tft.setTextSize(1);
}
#endif