#ifndef SENSORMODEL_H
#define SENSORMODEL_H

/**
// this class basically stores models of sensor to be used in other threads
**/

// battery model 
class BatteryModel
{
public:
    BatteryModel();
    BatteryModel(float b1C,float b1V,float b2C,float b2V);
    float batteryOneCurrent;
    float batteryOneVoltage;
    float batteryTwoCurrent;
    float batteryTwoVoltage;    
};

BatteryModel::BatteryModel()
{
    
}

BatteryModel::BatteryModel(float b1C, float b1V, float b2C, float b2V )
{
    batteryOneCurrent = b1C;
    batteryOneVoltage = b1V;
    batteryTwoCurrent = b2C;
    batteryTwoVoltage = b2V;    
}


// solar model
class SolarModel
{
public:
    SolarModel();
    SolarModel(float sV, float sC);
    float solarVoltage;
    float solarCurrent;    
};

SolarModel::SolarModel()
{
    
}

SolarModel::SolarModel(float sV, float sC)
{
    solarVoltage = sV;
    solarCurrent = sC;    
}

// consumption model
class ConsumptionModel
{
public:
    ConsumptionModel();
    ConsumptionModel(float oV, float oC);
    float consumptionVoltage;
    float consumptionCurrent;
};

ConsumptionModel::ConsumptionModel(float oV, float oC)
{
    consumptionVoltage = oV;
    consumptionCurrent = oC;
}
#endif