#ifndef VIEWLOGSCREEN_H
#define VIEWLOGSCREEN_H

#include "ListController.h"
#include "LogManager.h"
#include "RecordScreen.h"

class ViewLogScreen: public Button <ViewLogScreen>
{
public:
    ViewLogScreen(uint16_t backgroundColor); // constructor
    int start();
    void buttonPressed(int button);
private:
    void getLogRecords();    // this function fills the Log Array with records available
    void displayRecords();  // displays the available records
    void emptyRecords();    // empty the array that stores the records
    ListController *list;   // this is the list used to display the logs
    LogRecord records[4];      // array that stores a maximum of 4 log records
    int numberOfRecords;    // stores the number of records to show
    int changeScreen;
    uint16_t backgroundColor;   // stores the background color
    bool showDetails;   // knows when it is time to show a record's details
    bool scroll;
};

ViewLogScreen::ViewLogScreen(uint16_t bgColor)
{
    backgroundColor = bgColor;
}

int ViewLogScreen::start()
{
    // retireves the Log Records
    getLogRecords();
    // display those records on a list controller
    displayRecords();

    // attach interrupts to buttons
    Button<ViewLogScreen>::activateButtons(this);

    changeScreen = 0;
    showDetails = false;

    // have the infinite while loop that waits for an event
    while (changeScreen == 0) {
        //updateTile();
        //wait_ms(250);
       Thread::wait(250);  
       
       if (scroll){
            list->scroll();
            scroll = false;   
        } 

        if(showDetails && (numberOfRecords>0)) {
            // first deactivate the buttons
            Button<ViewLogScreen>::deActivateButtons();

            // then clear the screen
            tft.fillScreen(backgroundColor);

            // get the option selected
            int detail = (list->getCurrentOption())-1;

            // create record screen object
            RecordScreen recordScreen(backgroundColor);

            // launch record screen with appropriate object
            recordScreen.start(records[detail]);

            // recativate the buttons
            Button<ViewLogScreen>::activateButtons(this);
            
            // then clear the screen
            tft.fillScreen(backgroundColor);
            
            // show the data again
            list->drawList();

            // reset flag
            showDetails = false;
        }
    }

    // release memory back to heap
    delete list;

    // empty the records array
    emptyRecords();

    // dettach interrupts to buttons
    Button<ViewLogScreen>::deActivateButtons();

    return changeScreen;
}

void ViewLogScreen::getLogRecords()
{

    // create a Log Manager object
    // send the reference of the records array and Log Manager
    // will fill it with available records
    // it returns the number of records availble
    LogManager manager;
    numberOfRecords = manager.retrieveLog(records);

    // arrange records with according to time. The latest record first
    if(numberOfRecords > 1) {       
        for(int i = 0; i < (numberOfRecords-1); i++) {
            // compare a given record with all proceding records
            for( int j = 0; j < (numberOfRecords-1); j++) {     
                // check if the time of recording is earlier than the record of interest
                if(records[i].getTimeStamp() < records[j+1].getTimeStamp()) {
                    // swap records
                    LogRecord record = records[i];
                    records[i] = records[j+1];
                    records[j+1] = record;
                }
            }
        }

    }


    // use the data to construct a list controller with the data
}

void ViewLogScreen::displayRecords()
{

    myled2 = 1;
    list = new ListController( 0,
                               0,
                               "Logs",
                               records[0].getName(),
                               records[1].getName(),
                               records[2].getName(),
                               records[3].getName(),
                               backgroundColor,
                               numberOfRecords);


    list->drawList();

}

void ViewLogScreen::emptyRecords()
{

    for(int i = 0; i < 4; i++) {
        LogRecord record;   // empty record
        records[i] = record;    // store empty record
    }

    numberOfRecords = 0;    // there are now no records left
}

void ViewLogScreen::buttonPressed(int button)
{
    switch(button) {

        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;

        case SCROLLBUTTON:
            // scroll to the next option
            //list->scroll();
            scroll = true;
            break;

        case ENTERBUTTON:
            // navigate to the selected option
            //changeScreen = ListController::getCurrentOption();
            showDetails = true;
            break;

        default:
            // do nothing
            break;
    }
}


#endif