#ifndef SETTINGSSCREEN_H
#define SETTINGSSCREEN_H

#include "ListController.h"

class SettingsScreen: public Button <SettingsScreen>
{
public:
    SettingsScreen(uint16_t backgroundColor);
    int start();
    void buttonPressed(int button);

private:
    void drawSettingsScreen();
    int changeScreen;
    ListController *list;   // manages the list
    bool scroll;    // updated when a scroll event occurs
    bool enter;     // updated when an enter event occurs
    uint16_t bgColor;   // background color

};

SettingsScreen::SettingsScreen(uint16_t backgroundColor)
{

    bgColor = backgroundColor;
}

int SettingsScreen::start()
{

    // draw the screen
    drawSettingsScreen();

    // attach interrupts to buttons
    Button<SettingsScreen>::activateButtons(this);

    changeScreen = 0;
    scroll = false;
    enter = false;


    while (changeScreen == 0) {
        //updateTile();
        // scroll event occured
        if (scroll) {
            // perform scroll on the list
            list->scroll();
            // reset variable
            scroll = false;
        }

        // enter event occured
        if (enter) {
            // read the current option on the list
            changeScreen = list->getCurrentOption();
        }
        //wait_ms(500);
        Thread::wait(200);
    }
    
    // release memory occupied by list controller
    delete list;

    // dettach interrupts to buttons
    Button<SettingsScreen>::deActivateButtons();

    return changeScreen;
}

void SettingsScreen::drawSettingsScreen()
{

    // construct the list
    
    /**
    list = new ListController( 0,
                               0,
                               "Settings",
                               "LCD Screen",
                               "Data Logs",
                               "",
                               "",
                               backgroundColor,
                               2);
                               
    **/
    
    list = new ListController( 0,
                               0,
                               "Settings",
                               "LCD Screen",
                               "",
                               "",
                               "",
                               backgroundColor,
                               1);

    // draw the list
    list->drawList();
}

void SettingsScreen::buttonPressed(int button)
{
    switch(button) {

        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;

        case SCROLLBUTTON:
            // scroll to the next option
            scroll = true;
            break;

        case ENTERBUTTON:
            // navigate to the selected option
            enter = true;

        default:
            // do nothing
            break;
    }
}

#endif