#ifndef LOGDURATIONSCREEN_H
#define LOGDURATIONSCREEN_H

#include "ListController.h"

class LogDurationScreen:public Button <LogDurationScreen>
{
public:
    LogDurationScreen(uint16_t backgroundColor);
    int start();
    void buttonPressed(int button);

private:
    void drawLogDurationScreen();
    int changeScreen;
    ListController *list;   // manages the list controller
    bool scroll;    // updated when a scroll event occurs
    bool enter;     // updated when an enter event occurs
    uint16_t bgColor;   // stores the background color

};

LogDurationScreen::LogDurationScreen(uint16_t backgroundColor)
{
    bgColor = backgroundColor;

}

int LogDurationScreen::start()
{

    // draw the screen
    drawLogDurationScreen();

    // attach interrupts to buttons
    Button<LogDurationScreen>::activateButtons(this);

    changeScreen = 0;
    scroll = false;
    enter = false;


    while (changeScreen == 0) {
        //updateTile();

        // if scroll event occured
        if (scroll) {
            // perform scroll on list
            list->scroll();
            // reset variable
            scroll = false;
        }

        // enter event occured
        if (enter) {
            // read the current option on the list
            changeScreen = list->getCurrentOption();
        }
        //wait_ms(200);
        Thread::wait(200);
    }
    
    // release the memory held by the list
    delete list;

    // dettach interrupts to buttons
    Button<LogDurationScreen>::deActivateButtons();

    return changeScreen;
}

void LogDurationScreen::drawLogDurationScreen()
{

    // construct the list
    list = new ListController( 0,
                               0,
                               "Duration",
                               "30 seconds",
                               "10 minutes",
                               "",
                               "",
                               bgColor,
                               2);

    // draw the list
    list->drawList();
}

void LogDurationScreen::buttonPressed(int button)
{
    switch(button) {

        case BACKBUTTON:
            // navigate to the previous screen
            changeScreen = -1;
            break;

        case SCROLLBUTTON:
            // scroll to the next option
            scroll = true;
            break;

        case ENTERBUTTON:
            // navigate to the selected option
            enter = true;
            break;

        default:
            // do nothing
            break;
    }
}

#endif