#ifndef LOGMANAGER_H
#define LOGMANAGER_H

#include "LogRecord.h"

// stores
struct LogInstructions{
    int parameter;
    int duration;    
} logInstructions;  


const static char *LOGDATA_LOC = "/local/log.txt";
const static char *LOGDATA1_LOC = "/local/log6.txt";
const static char *LOGDATA2_LOC = "/local/log2.txt";
const static char *LOGDATA3_LOC = "/local/log5.txt";
const static char *LOGDATA4_LOC = "/local/log4.txt";


class LogManager
{
public:
    LogManager();
    void createNewLog(int parameter, int duration);
    int retrieveLog(LogRecord records[]);
    void deleteLog(LogRecord &);
private:
    void createLogStructure();
    void updateLog();
    bool logFileExists();
    bool logAvailable(int &);
    void readData(MbedJSONValue &, const char *location);
    void writeData(MbedJSONValue &, const char *location);

    char currLog[5];    // stores the log id of the current log
    char logLocation[20];   // location of the current log
    LogRecord *record;      // is used a buffer to store record data
    Ticker timer1; // create ticker object

};

LogManager::LogManager()
{
    // constructor
    myled = 1;

    // it first checks if the log file exists
    // and if not, creates the JSON data structure
    if(!logFileExists()) {

        createLogStructure();
    }

}

void LogManager::createNewLog(int parameter, int duration)
{
    // loops through the data structure to find an available
    // spot in the log structure
    


    int id = 0;
    if(!logAvailable(id)) {
        /// do some work
        // for example show display message
        return;
    }
    
    
    
    // determine the location of the log
    switch(id) {
        case 1:
            strcpy(logLocation,LOGDATA1_LOC);
            break;
        case 2:
            strcpy(logLocation,LOGDATA2_LOC);
            break;
        case 3:
            strcpy(logLocation,LOGDATA3_LOC);
            break;
        case 4:
            strcpy(logLocation,LOGDATA4_LOC);
            break;
        default:
            break;
    }
    
    

    // id will have the location of the empty log
    //create Log ID
    strcpy(currLog,"l");
    char num[2];
    sprintf(num,"%d",id);
    strcat(currLog,num);


    // intialises the log structure
    // e.g parameter, duration etc

    // create temporary JSON object
    MbedJSONValue temp;
    // populate JSONObject
    readData(temp,logLocation);

    // intialises the log structure
    // e.g parameter, duration etc
    

    record = new LogRecord(currLog);
    record->initialiseRecord(temp,parameter,duration);
    
    
    // write the data to file
    writeData(temp,logLocation);
    

    
    //RtosTimer timer()

    // set an interrupt to do this depending on the interval
    timer1.attach(callback(this,&LogManager::updateLog),10.0); // call ISR every 10.0 seconds

    // starts updating the log
    updateLog();
    
    
    
}

void LogManager::updateLog()
{

    // update the record with necessary data
    //// REMEMBER TO WAIT BEFORE PERMISSION IS GRANTED

    // read the log from logstructure on file
    // this will be a JSON object

    // create temporary JSON object
    MbedJSONValue temp;
    // populate JSONObject


    readData(temp,logLocation);
    //  update the JSON object
    if (record->updateRecord(temp)) { // check if logging is unfinished
        // write the new JSON data to file
        writeData(temp,logLocation);
    } else {
        // Logging is complete
        // stop recurring interrupts here
        timer1.detach();

        // delete the Log Record
        delete record;

        // COMMIT SUICIDE
        delete this;
    }
}


bool LogManager::logFileExists()
{
    // this function checks whether the file
    // that stores log data exists

    FILE *file;
    if (file = fopen(LOGDATA1_LOC, "r")) {
        fclose(file);
        return true;
    }
    return false;
}

bool LogManager::logAvailable( int &id)
{
    // check if there is a space available for logging
    bool positionAvailable = false;
    // create location buffer
    char location[20];

    // loop through logs to check if there is a free position
    for( int i = 0; i < 4; i++ ) {

        int number = i+1;

        // determine location
        switch(number) {
            case 1:
                strcpy(location,LOGDATA1_LOC);
                break;
            case 2:
                strcpy(location,LOGDATA2_LOC);
                break;
            case 3:
                strcpy(location,LOGDATA3_LOC);
                break;
            case 4:
                strcpy(location,LOGDATA4_LOC);
                break;
            default:
                break;
        }

        // create temporary JSON object
        MbedJSONValue temp;
        // populate JSON object
        readData(temp,location);

        //create Log ID
        char logID[] = "l";
        char num[2];
        sprintf(num,"%d",number);
        strcat(logID,num);

        // retrieve the status
        int status = temp[logID]["s"].get<int>();


        // check availability
        if(status == 0) {
            id = number;
            positionAvailable = true;
            break;
        }

    }

    return positionAvailable;

}


void LogManager::createLogStructure()
{
    // this function creates the json data structure
    // and stores it on file



    // create location buffer
    char location[20];

    // create 4 empty logs in the JSON Object
    for( int i = 0; i < 4; i++) {

        int number = i+1;

        // create new temporary JSON object
        MbedJSONValue temp;

        // determine location
        switch(number) {
            case 1:
                strcpy(location,LOGDATA1_LOC);
                break;
            case 2:
                strcpy(location,LOGDATA2_LOC);
                break;
            case 3:
                strcpy(location,LOGDATA3_LOC);
                break;
            case 4:
                strcpy(location,LOGDATA4_LOC);
                break;
            default:
                break;
        }

        //create Log ID
        char logID[] = "l";
        char num[2];
        sprintf(num,"%d",number);
        strcat(logID,num);

        temp[logID]["p"] = 0;
        temp[logID]["mx"] = 0;
        temp[logID]["mn"] = 0;
        temp[logID]["av"] = 0;
        temp[logID]["s"] = 0;
        temp[logID]["d"] = 0;
        temp[logID]["%"] = 0;
        temp[logID]["v"] = 0;
        temp[logID]["t"] = 0;

        // write the data to file
        writeData(temp,location);
    }
}

int LogManager::retrieveLog(LogRecord records[])
{
    // look for the unempty records by checking their status
    int numberOfRecords = 0;
    
    // location of record in array
    int position = 0;

    // create location buffer
    char location[20];

    for ( int i = 0; i < 4; i++) {
        int number = i+1;

        // determine location
        switch(number) {
            case 1:
                strcpy(location,LOGDATA1_LOC);
                break;
            case 2:
                strcpy(location,LOGDATA2_LOC);
                break;
            case 3:
                strcpy(location,LOGDATA3_LOC);
                break;
            case 4:
                strcpy(location,LOGDATA4_LOC);
                break;
            default:
                break;
        }

        // create temporary JSON Object
        MbedJSONValue temp;
        // populate JSON object
        readData(temp,location);

        //create Log ID
        char logID[] = "l";
        char num[2];
        sprintf(num,"%d",number);
        strcat(logID,num);

        // look for logs with data
        int status = temp[logID]["s"].get<int>();
        if(status != 0) {
            // logfile is not empty therefore

            // create new record
            LogRecord newRecord(logID);
            newRecord.initialiseRecord(temp,number);

            // store the records in an array
            records[position] = newRecord;
            position++;

            // increment the record counter
            numberOfRecords++;
        }
    }

    return numberOfRecords;
}

void LogManager::deleteLog(LogRecord &record)
{
    // this function resets the log data
    // in the log structure to the default values

    // first determine the location
    // create location buffer
    char location[20];

    switch(record.getID()) {
        case 1:
            strcpy(location,LOGDATA1_LOC);
            break;
        case 2:
            strcpy(location,LOGDATA2_LOC);
            break;
        case 3:
            strcpy(location,LOGDATA3_LOC);
            break;
        case 4:
            strcpy(location,LOGDATA4_LOC);
            break;
        default:
            break;
    }

    // create temporary JSON Object
    MbedJSONValue temp;

    //create Log ID
    char logID[] = "l";
    char num[2];
    sprintf(num,"%d",record.getID());
    strcat(logID,num);

    // create empty log
    temp[logID]["p"] = 0;
    temp[logID]["mx"] = 0;
    temp[logID]["mn"] = 0;
    temp[logID]["av"] = 0;
    temp[logID]["s"] = 0;
    temp[logID]["d"] = 0;
    temp[logID]["%"] = 0;
    temp[logID]["v"] = 0;
    temp[logID]["t"] = 0;
    
    // write the data to file
    writeData(temp,location);
    
    //wait_ms(100);
}

void LogManager::readData(MbedJSONValue &temp, const char *location)
{

    // buffer to store string read from file
    char read_string[100];
    // create the file pointer
    FILE *fp;
    // prepare file for reading
    fp = fopen(location, "r");
    // read the logs string into buffer
    fgets(read_string,100,fp);
    // convert string into JSON Data
    parse(temp,read_string);
    // close the file
    fclose(fp);
}

void LogManager::writeData(MbedJSONValue &temp, const char *location)
{
    // create the file pointer
    FILE *fp;
    // prepare file for writing
    fp = fopen(location, "w");
    // convert json object to string
    std::string s;
    s = temp.serialize();
    // write string to file
    fprintf(fp,"%s",s.c_str());
    // close the file
    fclose(fp);
}

#endif