#ifndef INPUTS_H
#define INPUTS_H

#include "SensorModel.h"
#include "SensorSuite.h"

#define SCROLLBUTTON    1
#define ENTERBUTTON     2
#define BACKBUTTON      3

InterruptIn enterButton(p21);
InterruptIn scrollButton(p22);
InterruptIn backButton(p23);
Timer debounce;
Ticker timerRefresh;

AnalogIn ain(p20);
//float ain = 0.5;
//float ain1 = 0.5;
//float ain2 = 0.5;
AnalogIn ain1(p19);
AnalogIn ain2(p18);

int getBatteryPercentage()
{

    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    BatteryModel model;
    model = suite.getBatteryData();
    
    float percentage1 = ((model.batteryOneVoltage-3.0)/1.2)*100;
    
    float percentage2 = ((model.batteryTwoVoltage-3.0)/1.2)*100;
    
    // because battery one has 6600mAH and battery two has 4400mAH
    int percentage = percentage1*0.6+percentage2*0.4;

    return percentage;
}

int getBatteryOnePercentage()
{
    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    BatteryModel model;
    model = suite.getBatteryData();
    
    int percentage = ((model.batteryOneVoltage-3.0)/1.2)*100;
    return percentage;
}

int getBatteryTwoPercentage()
{
    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    BatteryModel model;
    model = suite.getBatteryData();
    
    int percentage = ((model.batteryTwoVoltage-3.0)/1.2)*100;
    
    return percentage;
}

int getBatteryStatus()
{

    /////// remember to use an integer ////////
    // 0 - none of the batteries are charging
    // 1 - battery one is charging
    // 2 - battery two is charging
    // 3 - all batteries are charging


    int batteryCharging;

    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    BatteryModel model;
    model = suite.getBatteryData();

    //  determine the batteries' status
    if(model.batteryOneCurrent > -0.5 && model.batteryTwoCurrent > -0.5) {
        // none of the batteries are charging
        batteryCharging = 0;
    } else if ( model.batteryOneCurrent < -0.5 && model.batteryTwoCurrent > -0.5) {
        // only battery one is charging
        batteryCharging = 1;
    } else if (model.batteryOneCurrent > -0.5 && model.batteryTwoCurrent < -0.5) {
        // only battery two is charging
        batteryCharging = 2;
    } else if (model.batteryOneCurrent < -0.5 && model.batteryTwoCurrent < -0.5) {
        // both batteries are charging
        batteryCharging = 3;
    }

    // return the battery status
    return batteryCharging;
}



bool getOutputStatus()
{

    bool outputStatus;
    
    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get consumption data
    ConsumptionModel model = suite.getConsumptionData();

    // read the current
    if (model.consumptionCurrent > 20) {
        outputStatus = true;
    } else {
        outputStatus = false;
    }

    // return the output status
    return outputStatus;
}

bool getSolarStatus()
{

    bool radiationReceived;

    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    SolarModel model = suite.getSolarData();

    // read the potentiometer
    if (model.solarCurrent > 0.5) {
        radiationReceived = true;
    } else {
        radiationReceived = false;
    }

    // return the solar panel status
    return radiationReceived;
}

float getSolarPower()
{
    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    SolarModel model = suite.getSolarData();

    // return the power
    if (model.solarCurrent > 0.5) {
        return model.solarCurrent*model.solarVoltage*0.001;
    } else {
        return 0.0;
    }
}

float getConsumptionPower()
{
    // Define SensorSuite class to access the data
    SensorSuite suite;
    // create sensor model to get battery data
    ConsumptionModel model = suite.getConsumptionData();

    // return the power
    if (model.consumptionCurrent > 0.5) {
        return model.consumptionCurrent*model.consumptionVoltage*0.001;
    } else {
        return 0.0;
    }
}

template < class T >
class Button
{

public:

    //virtual void buttonPressed(int button) = 0;

    void activateButtons(T *ptr) {

        var = ptr;

        enterButton.rise(callback(this,&Button::enterButtonPressed));
        scrollButton.rise(callback(this,&Button::scrollButtonPressed));
        backButton.rise(callback(this,&Button::backButtonPressed));

        debounceRefresher();
        startDebouncer();

    }

    void deActivateButtons() {

        enterButton.rise(NULL);
        scrollButton.rise(NULL);
        backButton.rise(NULL);
    }


    void scrollButtonPressed() {

        if(debounceSuccessful()) {
            // toggle led
            var->buttonPressed(SCROLLBUTTON);
            resetDebouncer();
        }

    }

    void enterButtonPressed() {
        if(debounceSuccessful()) {
            // toggle led
            var->buttonPressed(ENTERBUTTON);
            resetDebouncer();
        }
    }

    void backButtonPressed() {
        if(debounceSuccessful()) {
            // toggle led
            var->buttonPressed(BACKBUTTON);
            resetDebouncer();
        }
    }

    void startDebouncer() {
        // start the debounce timer
        debounce.start();
    }

    void resetDebouncer() {
        // reset the dobounce timer
        debounce.reset();
    }

    void debounceRefresher() {
        // endsuer the debounce timer is
        // reset every 20 minutes to
        // prevent ghosting/memory loss
        timerRefresh.attach(callback(this,&Button::resetDebouncer),1200.0);
    }

    bool debounceSuccessful() {

        if (debounce.read_ms() > 200) { // check if the debounce timer is more than 200ms

            return true;
        } else {
            return false;
        }

    }

    // void pointer
public:
    T *var;


};

#endif
