#ifndef SETTINGSICON_H
#define SETTINGSICON_H

class SettingsIcon
{
public:
    SettingsIcon(uint8_t xCoordinate, uint8_t yCoordinate, uint16_t backgroundColor );
    void drawSettingsIcon();

private:    
    uint8_t startingWidth;
    uint8_t startingHeight;
    uint16_t bgColor;
    uint16_t drawColor;
};

SettingsIcon::SettingsIcon(uint8_t xCoordinate, uint8_t yCoordinate, uint16_t backgroundColor){
    
    // set the centre of the big circle
    startingWidth = xCoordinate + 23;
    startingHeight = yCoordinate + 23;

    // set the backgroundColor
    bgColor = backgroundColor;
    
    // determine the color of the lines on the solar panel
    if (bgColor == ST7735_WHITE ) {
        drawColor = ST7735_BLACK;
    } else if (bgColor == ST7735_BLACK) {
        drawColor = ST7735_WHITE;
    }
    
}

void SettingsIcon::drawSettingsIcon(){
    
    // radii of outer circles (background circles)
    int outerRad = 7;
    
    // radius of inner circle (background circle)
    int innerRad = 7;
    
    // radius of big circle
    int rad = 23;
    
    // distance to radius of circles along the horizontal 
    // and vertical axis of the big circle
    int horAndVar = 23; 
    
    // distance to radius of circles at 45 degrees 
    // from the centre of the big circle
    int sides = 16; 
    
    
    // draw big circle
    tft.fillCircle(startingWidth, startingHeight, rad, drawColor);  
    
    // draw inner small background circle
    tft.fillCircle(startingWidth, startingHeight, innerRad, bgColor);
    
    // draw outer small background circles
    
    // along vertical and horizontal axis
    tft.fillCircle(startingWidth, startingHeight-horAndVar, outerRad, bgColor);
    tft.fillCircle(startingWidth, startingHeight+horAndVar, outerRad, bgColor);
    
    tft.fillCircle(startingWidth-horAndVar, startingHeight, outerRad, bgColor);
    tft.fillCircle(startingWidth+horAndVar, startingHeight, outerRad, bgColor);
    
    // along 45 degrees
    tft.fillCircle(startingWidth+sides, startingHeight-sides, outerRad, bgColor);
    tft.fillCircle(startingWidth+sides, startingHeight+sides, outerRad, bgColor);
    
    tft.fillCircle(startingWidth-sides, startingHeight-sides, outerRad, bgColor);
    tft.fillCircle(startingWidth-sides, startingHeight+sides, outerRad, bgColor);    
}
#endif