#include "mbed.h"

Timer timer2;

extern double ultrasonicValue[4];
extern uint16_t ultrasonicVal[4];
extern void Ultrasonic(void);

/* robocup */

#define RATE    0.052
#define Long    1.0
#define ENTER   0
#define EXIT    1
#define X       0
#define Y       1
#define MOT_NUM 4
#define MOTDRIVER_WAIT  300 //ms
#define BAUD_RATE       115200
#define BAUD_RATE2      19200
#define BUT_WAIT        0.3 //s
#define ON      1
#define OFF     0

#define PING_ERROR  0xFFFF
#define PI          3.14159265

#define MOT1    1.0
#define MOT2    1.0
#define MOT3    1.0
#define MOT4    1.0

#define PID_BIAS    0.0
#define REFERENCE   180.0
#define MINIMUM     0.0
#define MAXIMUM     360.0

#define PID_CYCLE   0.06    //s

#define P_GAIN  0.75    //0.78   
#define I_GAIN  0.0     //0.0
#define D_GAIN  0.006   //0.009
    
#define OUT_LIMIT   30.0
#define MAX_POW     100
#define MIN_POW     -100

DigitalOut led1(LED1); 
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
BusOut mbedleds(LED4,LED3,LED2,LED1); 
HMC6352 compass(p28, p27);
//Serial driver(p28, p27);    // tx, rx 
Serial device2(p13, p14);   // tx, rx
Serial pc(USBTX, USBRX);    // tx, rx 
//DigitalIn StartButton(p21);
//DigitalIn CalibEnterButton(p22);
DigitalIn CalibExitButton(p23);
DigitalIn EEPROMButton(p24);
//PID pid(P_GAIN,I_GAIN,D_GAIN, RATE);      //battery is low power version 30.0 0.58 1.0 0.015    battery is high power version   30.0 0.42, 1.0, 0.013   power is low but perfect 20.0 0.45, 0.0, 0.010
Ticker pidUpdata;
Ticker irDistanceUpdata;
Timer timer1;
Timer Survtimer;
LocalFileSystem local("local");  // マウントポイントを定義（ディレクトリパスになる）

enum{
    NORMAL,
    LEFT_OUT,
    RIGHT_OUT,
    FRONT_OUT,
    BACK_OUT,
};

enum{
    HOME_WAIT,
    DIFFENCE,
    WARNING,
    HOLD,
};

PinName adc_num[6] = {
    p15,
    p16,
    p17,
    p18,
    p19,
    p20,
};
double standTu = 0;
int speed[MOT_NUM] = {0};
uint8_t hold_flag = 0;
uint8_t state = HOME_WAIT;
uint8_t lineState = NORMAL;

double inputPID = 180.0;
static double standard;
double compassPID = 0.0;