#include "mbed.h"
#include "ColorSensor.h"

ColorSensor color(p20, p17, p18, p19, 10);
//ColorSensor color = ColorSensor();
Serial pc(USBTX, USBRX); // tx, rx

DigitalOut led[4] = {LED1,LED2,LED3,LED4};
DigitalOut air[2]={p21,p22};

int main()
{
  unsigned R, G, B;
  double color_sum;
  double redp,greenp,bluep;
  //pc.baud(115200);
  air[0] = 0; air[1] = 1;
  
  while(1)
  {
    color.getRGB(R, G, B);
    
    color_sum = (R * 0.65) + G + (B * 1.3);
    
    redp = (double)(R * 0.65)/color_sum * 100;
    greenp = (double)G/color_sum * 100;
    bluep = (double)(B * 1.3)/color_sum * 100;
    
    pc.printf("R:%lf G:%lf B:%lf\n", redp, greenp, bluep);
    
    
    if(redp >= 55){
            led[0] = 1; led[1] = 1; led[2] = 1; led[3] = 1;
            air[0] = 1;  air[1] = 0;
            wait(0.5);
            led[0] = 0; led[1] = 0; led[2] = 0; led[3] = 0;
            air[0] = 0;  air[1] = 1;
            wait(2);
    }else{
            led[0] = 0; led[1] = 0; led[2] = 0; led[3] = 0;
    }
    
    
    /*
    switch(color.judge()){
      case RED: pc.printf("RED\n"); break;
      case GREEN: pc.printf("GREEN\n"); break;
      case BLUE: pc.printf("BLUE\n"); break;
      default: break;
    }
    */
    //wait_ms(5);
  }
}